/*
 * Decompiled with CFR 0.152.
 */
package universum.studios.android.officium.service.auth;

import android.support.annotation.NonNull;
import java.io.IOException;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import universum.studios.android.officium.service.auth.AuthTokenProvider;

public final class AuthRequestInterceptor
implements Interceptor {
    public static final String HEADER_NAME = "Authorization";
    private final AuthTokenProvider tokenProvider;

    public AuthRequestInterceptor(@NonNull AuthTokenProvider tokenProvider) {
        this.tokenProvider = tokenProvider;
    }

    public Response intercept(@NonNull Interceptor.Chain chain) throws IOException {
        String authToken = this.tokenProvider.peekToken();
        Request request = chain.request();
        return authToken == null || authToken.length() == 0 ? chain.proceed(request) : chain.proceed(request.newBuilder().header(HEADER_NAME, "Bearer " + authToken).build());
    }
}

