/*
 * Decompiled with CFR 0.152.
 */
package universum.studios.android.officium.service;

import android.support.annotation.CallSuper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import okhttp3.HttpUrl;
import retrofit2.Retrofit;
import universum.studios.android.officium.service.EndPoint;

public class ServiceManager {
    private HttpUrl baseUrl;
    private final Map<Class<?>, ServicesConfiguration> services = new HashMap(1);
    @Deprecated
    private EndPoint endPoint;

    public ServiceManager(@NonNull String baseUrl) {
        this(HttpUrl.parse((String)baseUrl));
    }

    public ServiceManager(@NonNull HttpUrl baseUrl) {
        this.baseUrl = baseUrl;
    }

    @Deprecated
    public ServiceManager(@NonNull EndPoint endPoint) {
        this.endPoint = endPoint;
        this.baseUrl = HttpUrl.parse((String)endPoint.getBaseUrl());
    }

    @Deprecated
    public ServiceManager() {
        this.endPoint = null;
        this.baseUrl = null;
    }

    @NonNull
    public HttpUrl getBaseUrl() {
        return this.baseUrl;
    }

    @Deprecated
    public void setEndPoint(final @NonNull String baseUrl) {
        this.setEndPoint(new EndPoint(){

            @Override
            @NonNull
            public String getBaseUrl() {
                return baseUrl;
            }
        });
    }

    @Deprecated
    public void setEndPoint(@NonNull EndPoint endPoint) {
        this.endPoint = endPoint;
        this.baseUrl = HttpUrl.parse((String)endPoint.getBaseUrl());
    }

    @Deprecated
    @Nullable
    public EndPoint getEndPoint() {
        return this.endPoint;
    }

    @NonNull
    public <S> S services(@NonNull Class<S> servicesInterface) {
        return this.ensureServicesConfiguration(servicesInterface).services();
    }

    @NonNull
    public <S> ServicesConfiguration<S> servicesConfiguration(@NonNull Class<S> servicesInterface) {
        return this.ensureServicesConfiguration(servicesInterface);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <S> ServicesConfiguration<S> ensureServicesConfiguration(Class<S> servicesInterface) {
        Map<Class<?>, ServicesConfiguration> map = this.services;
        synchronized (map) {
            ServicesConfiguration<S> servicesConfiguration = this.services.get(servicesInterface);
            if (servicesConfiguration == null) {
                servicesConfiguration = this.onCreateServicesConfiguration(servicesInterface);
                this.services.put(servicesInterface, servicesConfiguration);
            }
            return servicesConfiguration;
        }
    }

    @CallSuper
    @NonNull
    protected <S> ServicesConfiguration<S> onCreateServicesConfiguration(@NonNull Class<S> servicesInterface) {
        ServicesConfiguration<S> configuration = new ServicesConfiguration<S>(servicesInterface);
        configuration.retrofitBuilder().baseUrl(this.baseUrl);
        return configuration;
    }

    public static final class ServicesConfiguration<S> {
        private final Retrofit.Builder builder = new Retrofit.Builder();
        private final Class<S> servicesInterface;
        private S services;
        private Retrofit retrofit;
        private volatile boolean changed = true;

        ServicesConfiguration(@NonNull Class<S> servicesInterface) {
            this.servicesInterface = servicesInterface;
        }

        @NonNull
        public Retrofit.Builder retrofitBuilder() {
            return this.builder;
        }

        @NonNull
        public Retrofit retrofit() {
            this.ensureValid();
            return this.retrofit;
        }

        @NonNull
        S services() {
            this.ensureValid();
            return this.services;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void ensureValid() {
            if (this.changed) {
                Retrofit.Builder builder = this.builder;
                synchronized (builder) {
                    this.retrofit = this.builder.build();
                    this.services = this.retrofit.create(this.servicesInterface);
                    this.changed = false;
                }
            }
        }

        public void invalidate() {
            this.changed = true;
        }
    }
}

