/*
 * Decompiled with CFR 0.152.
 */
package universum.studios.android.officium.sync;

import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.google.gson.Gson;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class SyncTask<R extends Request>
implements Cloneable {
    public static final int IDLE = 0;
    public static final int PENDING = 1;
    public static final int RUNNING = 2;
    public static final int FINISHED = 3;
    public static final int FAILED = 4;
    public static final int CANCELED = 5;
    public static final int DEFAULT_ID = 0;
    public static SyncTask<EmptyRequest> EMPTY = new SyncTask();
    private static final Gson GSON = new Gson();
    private final int mId;
    private R mRequest;
    private final String mRequestBody;
    private int mState = 0;

    private SyncTask() {
        this.mId = -1;
        this.mRequestBody = null;
    }

    private SyncTask(SyncTask other) {
        this.mId = other.mId;
        this.mRequestBody = other.mRequestBody;
        this.mState = other.mState;
    }

    protected SyncTask(@NonNull Builder<R> builder) {
        this.mId = ((Builder)builder).id;
        this.mRequest = ((Builder)builder).request;
        this.mRequestBody = this.mRequest != null ? GSON.toJson(this.mRequest) : null;
    }

    protected SyncTask(@NonNull Bundle extras) {
        this.mId = extras.getInt("universum.studios.android.officium.sync.EXTRA.Task.Id", 0);
        this.mRequestBody = extras.getString("universum.studios.android.officium.sync.EXTRA.Task.RequestBody");
        this.mState = extras.getInt("universum.studios.android.officium.sync.EXTRA.Task.State", this.mState);
    }

    public final int getId() {
        return this.mId;
    }

    final void setState(int state) {
        this.mState = state;
    }

    public final int getState() {
        return this.mState;
    }

    @Nullable
    public final R getRequest(@NonNull Class<R> classOfRequest) {
        if (this.mRequest == null) {
            this.mRequest = !TextUtils.isEmpty((CharSequence)this.mRequestBody) ? (Request)GSON.fromJson(this.mRequestBody, classOfRequest) : null;
        }
        return this.mRequest;
    }

    @Nullable
    public final String getRequestBody() {
        return this.mRequestBody;
    }

    @NonNull
    public Bundle intoExtras(@NonNull Bundle extras) {
        extras.putInt("universum.studios.android.officium.sync.EXTRA.Task.Id", this.mId);
        extras.putString("universum.studios.android.officium.sync.EXTRA.Task.RequestBody", this.mRequestBody);
        extras.putInt("universum.studios.android.officium.sync.EXTRA.Task.State", this.mState);
        return extras;
    }

    public int hashCode() {
        int hash = this.mId;
        if (!TextUtils.isEmpty((CharSequence)this.mRequestBody)) {
            hash = 31 * hash + this.mRequestBody.hashCode();
        }
        return hash;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof SyncTask)) {
            return false;
        }
        SyncTask task = (SyncTask)other;
        if (task.mId != this.mId) {
            return false;
        }
        int requestHash = this.mRequestBody != null ? this.mRequestBody.hashCode() : 0;
        int otherRequestHash = task.mRequestBody != null ? task.mRequestBody.hashCode() : 0;
        return requestHash == otherRequestHash;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(64);
        builder.append(this.getClass().getSimpleName());
        builder.append("{id: ");
        builder.append(this.mId);
        builder.append(", request: ");
        builder.append(this.mRequest != null ? this.mRequest : this.mRequestBody);
        builder.append(", state: ");
        builder.append(SyncTask.stateName(this.mState));
        return builder.append("}").toString();
    }

    private static String stateName(int state) {
        switch (state) {
            case 0: {
                return "IDLE";
            }
            case 1: {
                return "PENDING";
            }
            case 2: {
                return "RUNNING";
            }
            case 3: {
                return "FINISHED";
            }
            case 4: {
                return "FAILED";
            }
        }
        return "UNKNOWN";
    }

    protected SyncTask clone() {
        SyncTask<R> clone = new SyncTask<R>(this);
        clone.mState = 0;
        return clone;
    }

    public static class Builder<R extends Request> {
        private final int id;
        private R request;

        public Builder(int taskId) {
            this.id = taskId;
        }

        public Builder request(@Nullable R request) {
            this.request = request;
            return this;
        }

        @NonNull
        public SyncTask<R> build() {
            return new SyncTask(this);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface State {
    }

    public static final class EmptyRequest
    implements Request {
        private EmptyRequest() {
        }
    }

    public static interface Request {
    }
}

