/*
 * Decompiled with CFR 0.152.
 */
package universum.studios.android.officium.sync;

import android.accounts.Account;
import android.text.TextUtils;
import universum.studios.android.officium.sync.SyncTask;

public final class SyncOperation {
    public final Account account;
    public final String authority;
    public final SyncTask task;

    private SyncOperation(Builder builder) {
        this.account = builder.account;
        this.authority = builder.authority;
        this.task = builder.task;
    }

    static final class Builder {
        Account account;
        String authority;
        SyncTask task;

        Builder() {
        }

        Builder account(Account account) {
            this.account = account;
            return this;
        }

        Builder authority(String authority) {
            this.authority = authority;
            return this;
        }

        Builder task(SyncTask task) {
            this.task = task;
            return this;
        }

        SyncOperation build() {
            if (this.account == null) {
                throw new IllegalArgumentException("No account specified!");
            }
            if (TextUtils.isEmpty((CharSequence)this.authority)) {
                throw new IllegalArgumentException("No authority specified!");
            }
            if (this.task == null) {
                throw new IllegalArgumentException("No task specified!");
            }
            return new SyncOperation(this);
        }
    }
}

