/*
 * Decompiled with CFR 0.152.
 */
package universum.studios.android.officium.sync;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import universum.studios.android.officium.sync.SyncOperation;
import universum.studios.android.officium.sync.SyncTask;

public abstract class SyncHandler<Request extends SyncTask.Request, Result> {
    private final int mTaskId;
    private final Class<Request> mRequestClass;

    protected SyncHandler(int taskId) {
        this.mTaskId = taskId;
        this.mRequestClass = null;
    }

    protected SyncHandler(int taskId, @Nullable Class<Request> classOfRequest) {
        this.mTaskId = taskId;
        this.mRequestClass = classOfRequest;
    }

    public final int getTaskId() {
        return this.mTaskId;
    }

    @Nullable
    public final Result handleSync(@NonNull Context context, @NonNull SyncOperation syncOperation) {
        Request syncRequest = this.mRequestClass != null ? (Request)syncOperation.task.getRequest(this.mRequestClass) : null;
        try {
            return this.onHandleSync(context, syncOperation, syncRequest);
        }
        catch (Exception error) {
            this.onSyncError(context, syncOperation, syncRequest, error);
            return null;
        }
    }

    @Nullable
    protected abstract Result onHandleSync(@NonNull Context var1, @NonNull SyncOperation var2, @Nullable Request var3) throws Exception;

    protected void onSyncError(@NonNull Context context, @NonNull SyncOperation syncOperation, @Nullable Request syncRequest, @NonNull Exception error) {
        Log.e((String)this.getClass().getSimpleName(), (String)"An error occurred during synchronization handling!", (Throwable)error);
    }
}

