/*
 * Decompiled with CFR 0.152.
 */
package universum.studios.android.officium.sync;

import android.accounts.Account;
import android.os.Bundle;
import android.support.annotation.NonNull;

public class SyncEvent {
    public static final int START = 1;
    public static final int PROGRESS = 2;
    public static final int FINISH = 3;
    public static final int ERROR = 4;
    public final int id;
    public final int type;
    public final int progress;
    public final Exception error;
    public final Account account;
    public final Bundle extras;

    private SyncEvent(@NonNull Builder builder) {
        this.id = builder.id;
        this.type = builder.type;
        this.progress = builder.progress;
        this.error = builder.error;
        this.account = builder.account;
        this.extras = builder.extras;
    }

    public static class Builder {
        private final int id;
        private int type;
        private int progress;
        private Exception error;
        private Account account;
        private Bundle extras;

        public Builder(int id) {
            this.id = id;
        }

        public Builder type(int type) {
            this.type = type;
            return this;
        }

        public Builder progress(int progress) {
            this.progress = progress;
            return this;
        }

        public Builder error(@NonNull Exception error) {
            this.error = error;
            return this;
        }

        public Builder account(@NonNull Account account) {
            this.account = account;
            return this;
        }

        public Builder extras(@NonNull Bundle extras) {
            this.extras = extras;
            return this;
        }

        @NonNull
        public SyncEvent build() {
            return new SyncEvent(this);
        }
    }
}

