/*
 * Decompiled with CFR 0.152.
 */
package universum.studios.android.officium.sync;

import android.accounts.Account;
import android.content.ContentResolver;
import android.content.Context;
import android.os.Bundle;
import android.support.annotation.CallSuper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import universum.studios.android.officium.OfficiumConfig;
import universum.studios.android.officium.sync.OnSyncTaskStateChangeListener;
import universum.studios.android.officium.sync.SyncTask;

public abstract class BaseSyncManager
implements OnSyncTaskStateChangeListener {
    private static final String TAG = "BaseSyncManager";
    protected final Context mContext;
    protected final String mAuthority;

    public BaseSyncManager(@NonNull Context context, @NonNull String authority) {
        this.mContext = context;
        this.mAuthority = authority;
    }

    public void startAutomaticSync() {
        this.setAutomaticSyncEnabled(true);
    }

    public void stopAutomaticSync() {
        this.setAutomaticSyncEnabled(false);
    }

    private void setAutomaticSyncEnabled(boolean enabled) {
        Account account = this.pickAccountForSync();
        if (account != null) {
            ContentResolver.setSyncAutomatically((Account)account, (String)this.mAuthority, (boolean)enabled);
        }
    }

    public void requestGlobalSync() {
        this.requestSync(new SyncTask.Builder(0).build());
    }

    public void requestSync(@NonNull SyncTask syncTask) {
        Account account = this.pickAccountForSync();
        if (account != null) {
            if (this.shouldRequestSync(syncTask, account)) {
                syncTask.setState(1);
                this.onSyncTaskStateChanged(syncTask, account);
                Bundle extras = syncTask.intoExtras(new Bundle());
                extras.putBoolean("force", true);
                extras.putBoolean("expedited", true);
                if (OfficiumConfig.LOG_ENABLED) {
                    Log.v((String)TAG, (String)("Requesting synchronization for task(" + syncTask + ")."));
                }
                ContentResolver.requestSync((Account)account, (String)this.mAuthority, (Bundle)extras);
            }
        } else if (OfficiumConfig.LOG_ENABLED) {
            Log.v((String)TAG, (String)("Cannot perform synchronization for task(" + syncTask + "). No account picked for synchronization."));
        }
    }

    protected boolean shouldRequestSync(@NonNull SyncTask syncTask, @NonNull Account account) {
        return true;
    }

    @Override
    @CallSuper
    public void onSyncTaskStateChanged(@NonNull SyncTask syncTask, @NonNull Account account) {
    }

    public boolean isSyncActive() {
        Account account = this.pickAccountForSync();
        return account != null && ContentResolver.isSyncActive((Account)account, (String)this.mAuthority);
    }

    public boolean isSyncPedning() {
        Account account = this.pickAccountForSync();
        return account != null && ContentResolver.isSyncPending((Account)account, (String)this.mAuthority);
    }

    public void cancelSync() {
        Account account = this.pickAccountForSync();
        if (account != null) {
            this.onCancelSync(account);
        }
    }

    protected void onCancelSync(@NonNull Account account) {
        ContentResolver.cancelSync((Account)account, (String)this.mAuthority);
    }

    @Nullable
    protected abstract Account pickAccountForSync();
}

