/*
 * Decompiled with CFR 0.152.
 */
package universum.studios.android.officium.sync;

import android.accounts.Account;
import android.content.AbstractThreadedSyncAdapter;
import android.content.ContentProviderClient;
import android.content.Context;
import android.content.SyncResult;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import android.util.SparseArray;
import universum.studios.android.officium.OfficiumConfig;
import universum.studios.android.officium.sync.OnSyncTaskStateChangeListener;
import universum.studios.android.officium.sync.SyncEvent;
import universum.studios.android.officium.sync.SyncHandler;
import universum.studios.android.officium.sync.SyncOperation;
import universum.studios.android.officium.sync.SyncTask;

public abstract class BaseSyncAdapter
extends AbstractThreadedSyncAdapter {
    private static final String TAG = "BaseSyncAdapter";
    private OnSyncTaskStateChangeListener mTaskStateChangeListener;
    private EventDispatcher mEventDispatcher;
    private SyncHandler mGlobalSyncHandler;
    private SparseArray<SyncHandler> mTaskHandlers;

    public BaseSyncAdapter(@NonNull Context context, boolean autoInitialize) {
        this(context, autoInitialize, false);
    }

    public BaseSyncAdapter(@NonNull Context context, boolean autoInitialize, boolean allowParallelSyncs) {
        super(context, autoInitialize, allowParallelSyncs);
    }

    protected final void setOnTaskStateChangeListener(@Nullable OnSyncTaskStateChangeListener listener) {
        this.mTaskStateChangeListener = listener;
    }

    protected final void setEventDispatcher(@Nullable EventDispatcher dispatcher) {
        this.mEventDispatcher = dispatcher;
    }

    @Nullable
    protected final EventDispatcher getEventDispatcher() {
        return this.mEventDispatcher;
    }

    protected void registerTaskHandler(@NonNull SyncHandler handler) {
        int taskId;
        if (this.mTaskHandlers == null) {
            this.mTaskHandlers = new SparseArray(5);
        }
        if (this.mTaskHandlers.indexOfKey(taskId = handler.getTaskId()) >= 0) {
            if (OfficiumConfig.DEBUG_LOG_ENABLED) {
                Log.v((String)TAG, (String)("Replacing old synchronization handler by a new one for task with id(" + taskId + ")."));
            }
            this.mTaskHandlers.append(taskId, (Object)handler);
        } else {
            if (OfficiumConfig.DEBUG_LOG_ENABLED) {
                Log.v((String)TAG, (String)("Registering new synchronization handler for task with id(" + taskId + ")."));
            }
            this.mTaskHandlers.append(taskId, (Object)handler);
        }
    }

    protected void unregisterTaskHandler(@NonNull SyncHandler handler) {
        if (this.mTaskHandlers != null && this.mTaskHandlers.size() > 0) {
            this.mTaskHandlers.remove(handler.getTaskId());
        }
    }

    protected void setGlobalSyncHandler(@Nullable SyncHandler handler) {
        this.mGlobalSyncHandler = handler;
    }

    @Nullable
    protected SyncHandler getGlobalSyncHandler() {
        return this.mGlobalSyncHandler;
    }

    public void onPerformSync(Account account, Bundle extras, String authority, ContentProviderClient provider, SyncResult syncResult) {
        SyncOperation syncOperation = new SyncOperation.Builder().account(account).authority(authority).task(this.createTaskFromExtras(extras)).build();
        this.changeTaskStateToAndNotify(syncOperation, 2);
        if (syncOperation.task.getId() == 0) {
            this.onPerformGlobalSync(syncOperation);
        } else {
            this.onPerformSync(syncOperation);
        }
    }

    @NonNull
    protected SyncTask createTaskFromExtras(@NonNull Bundle extras) {
        return new SyncTask(extras);
    }

    protected void onPerformGlobalSync(@NonNull SyncOperation syncOperation) {
        if (this.mGlobalSyncHandler == null) {
            return;
        }
        this.dispatchSyncEvent(new SyncEvent.Builder(syncOperation.task.getId()).type(1).account(syncOperation.account).build());
        try {
            this.mGlobalSyncHandler.handleSync(this.getContext(), syncOperation);
            this.changeTaskStateToAndNotify(syncOperation, 3);
            this.onGlobalSyncFinished(syncOperation);
        }
        catch (Exception error) {
            this.changeTaskStateToAndNotify(syncOperation, 4);
            this.onGlobalSyncFailed(syncOperation, error);
        }
    }

    protected void onGlobalSyncFinished(@NonNull SyncOperation syncOperation) {
        this.dispatchSyncEvent(new SyncEvent.Builder(syncOperation.task.getId()).type(3).account(syncOperation.account).build());
    }

    protected void onGlobalSyncFailed(@NonNull SyncOperation syncOperation, @NonNull Exception error) {
        this.dispatchSyncEvent(new SyncEvent.Builder(syncOperation.task.getId()).type(4).account(syncOperation.account).error(error).build());
    }

    protected void onPerformSync(@NonNull SyncOperation syncOperation) {
        SyncHandler taskHandler;
        SyncHandler syncHandler = taskHandler = this.mTaskHandlers != null ? (SyncHandler)this.mTaskHandlers.get(syncOperation.task.getId()) : null;
        if (taskHandler == null) {
            Log.e((String)TAG, (String)("No synchronization handler found for task with id(" + syncOperation.task.getId() + ")."));
            return;
        }
        this.dispatchSyncEvent(new SyncEvent.Builder(syncOperation.task.getId()).type(1).account(syncOperation.account).build());
        try {
            taskHandler.handleSync(this.getContext(), syncOperation);
            this.changeTaskStateToAndNotify(syncOperation, 3);
            this.onSyncFinished(syncOperation);
        }
        catch (Exception error) {
            this.changeTaskStateToAndNotify(syncOperation, 4);
            this.onSyncFailed(syncOperation, error);
        }
    }

    protected void onSyncFinished(@NonNull SyncOperation syncOperation) {
        this.dispatchSyncEvent(new SyncEvent.Builder(syncOperation.task.getId()).type(3).account(syncOperation.account).build());
    }

    protected void onSyncFailed(@NonNull SyncOperation syncOperation, @NonNull Exception error) {
        this.dispatchSyncEvent(new SyncEvent.Builder(syncOperation.task.getId()).type(4).account(syncOperation.account).error(error).build());
    }

    private void changeTaskStateToAndNotify(SyncOperation syncOperation, int state) {
        if (syncOperation.task.getState() != state) {
            syncOperation.task.setState(state);
            if (this.mTaskStateChangeListener != null) {
                this.mTaskStateChangeListener.onSyncTaskStateChanged(syncOperation.task, syncOperation.account);
            }
        }
    }

    protected void dispatchSyncEvent(@NonNull Object event) {
        if (this.mEventDispatcher != null) {
            this.mEventDispatcher.dispatch(event);
        }
    }

    public static interface EventDispatcher {
        public void dispatch(@NonNull Object var1);
    }
}

