/*
 * Decompiled with CFR 0.152.
 */
package universum.studios.android.officium.service.auth;

import android.support.annotation.NonNull;
import android.text.TextUtils;
import java.io.IOException;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import universum.studios.android.officium.service.auth.AuthTokenProvider;

public final class AuthRequestInterceptor
implements Interceptor {
    private final AuthTokenProvider tokenProvider;

    public AuthRequestInterceptor(@NonNull AuthTokenProvider tokenProvider) {
        this.tokenProvider = tokenProvider;
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        String authToken = this.tokenProvider.peekToken();
        Request request = chain.request();
        return TextUtils.isEmpty((CharSequence)authToken) ? chain.proceed(request) : chain.proceed(request.newBuilder().header("Authorization", "Bearer " + authToken).build());
    }
}

