/*
 * Decompiled with CFR 0.152.
 */
package universum.studios.android.officium.service;

import android.support.annotation.CallSuper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import java.util.HashMap;
import retrofit2.Retrofit;
import universum.studios.android.officium.service.EndPoint;

public class ServiceManager {
    private final HashMap<Class<?>, ServicesConfiguration> mServices = new HashMap(1);
    private EndPoint mEndPoint;

    public ServiceManager() {
        this.mEndPoint = null;
    }

    public ServiceManager(@NonNull EndPoint endPoint) {
        this.mEndPoint = endPoint;
    }

    public void setEndPoint(final @NonNull String baseUrl) {
        this.setEndPoint(new EndPoint(){

            @Override
            @NonNull
            public String getBaseUrl() {
                return baseUrl;
            }
        });
    }

    public void setEndPoint(@NonNull EndPoint endPoint) {
        this.mEndPoint = endPoint;
    }

    @Nullable
    public EndPoint getEndPoint() {
        return this.mEndPoint;
    }

    public <S> S services(@NonNull Class<S> servicesInterface) {
        this.ensureHasServicesConfiguration(servicesInterface);
        return (S)this.mServices.get(servicesInterface).services();
    }

    public <S> ServicesConfiguration<S> servicesConfiguration(@NonNull Class<S> servicesInterface) {
        this.ensureHasServicesConfiguration(servicesInterface);
        return this.mServices.get(servicesInterface);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureHasServicesConfiguration(Class<?> servicesInterface) {
        HashMap<Class<?>, ServicesConfiguration> hashMap = this.mServices;
        synchronized (hashMap) {
            ServicesConfiguration servicesConfiguration = this.mServices.get(servicesInterface);
            if (servicesConfiguration == null) {
                this.mServices.put(servicesInterface, this.onCreateServicesConfiguration(servicesInterface));
            }
        }
    }

    @NonNull
    @CallSuper
    protected ServicesConfiguration onCreateServicesConfiguration(@NonNull Class<?> servicesInterface) {
        ServicesConfiguration configuration = new ServicesConfiguration(servicesInterface);
        if (this.mEndPoint != null) {
            configuration.retrofitBuilder().baseUrl(this.mEndPoint.getBaseUrl());
        }
        return configuration;
    }

    public static final class ServicesConfiguration<S> {
        private final Retrofit.Builder BUILDER = new Retrofit.Builder();
        private final Class<S> servicesInterface;
        private S services;
        private Retrofit retrofit;
        private boolean changed = true;

        private ServicesConfiguration(@NonNull Class<S> servicesInterface) {
            this.servicesInterface = servicesInterface;
        }

        @NonNull
        public Retrofit.Builder retrofitBuilder() {
            return this.BUILDER;
        }

        public void invalidate() {
            this.changed = true;
        }

        @NonNull
        public Retrofit retrofit() {
            this.ensureValid();
            return this.retrofit;
        }

        @NonNull
        private S services() {
            this.ensureValid();
            return this.services;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void ensureValid() {
            Retrofit.Builder builder = this.BUILDER;
            synchronized (builder) {
                if (this.changed) {
                    this.retrofit = this.BUILDER.build();
                    this.services = this.retrofit.create(this.servicesInterface);
                    this.changed = false;
                }
            }
        }
    }
}

