/*
 * Decompiled with CFR 0.152.
 */
package universum.studios.android.officium.service;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import java.io.IOException;
import okhttp3.ResponseBody;
import retrofit2.Converter;
import universum.studios.android.officium.service.BaseServiceObject;

public class ServiceError
extends BaseServiceObject {
    private final Throwable mFailure;
    private final int mErrorCode;
    private final ResponseBody mErrorBody;
    private Converter<ResponseBody, ?> mErrorBodyConverter;

    public ServiceError(int errorCode, @NonNull ResponseBody errorBody) {
        this.mErrorCode = errorCode;
        this.mErrorBody = errorBody;
        this.mFailure = null;
    }

    public ServiceError(@NonNull Throwable failure) {
        this.mErrorCode = 0;
        this.mErrorBody = null;
        this.mFailure = failure;
    }

    public ServiceError(@NonNull ServiceError other) {
        this.mErrorCode = other.mErrorCode;
        this.mErrorBody = other.mErrorBody;
        this.mFailure = other.mFailure;
        this.mErrorBodyConverter = other.mErrorBodyConverter;
    }

    public final boolean isError() {
        return this.mErrorBody != null;
    }

    public int getErrorCode() {
        if (this.mErrorBody == null) {
            throw new NullPointerException("Not an error but a failure!");
        }
        return this.mErrorCode;
    }

    @NonNull
    public ResponseBody getErrorBody() {
        if (this.mErrorBody == null) {
            throw new NullPointerException("Not an error but a failure!");
        }
        return this.mErrorBody;
    }

    public void setErrorBodyConverter(@Nullable Converter<ResponseBody, ?> converter) {
        this.mErrorBodyConverter = converter;
    }

    @Nullable
    public <T> T getErrorBodyAs(@NonNull Class<T> classOfT) {
        if (this.mErrorBody == null) {
            throw new NullPointerException("Not an error but a failure!");
        }
        if (this.mErrorBodyConverter == null) {
            throw new NullPointerException("No error body converter specified!");
        }
        Object errorBody = null;
        try {
            errorBody = this.mErrorBodyConverter.convert((Object)this.mErrorBody);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("Specified class(" + classOfT + ") does not match that specified for converter!", e);
        }
        finally {
            this.mErrorBody.close();
        }
        return (T)errorBody;
    }

    public final boolean isFailure() {
        return this.mFailure != null;
    }

    @NonNull
    public Throwable getFailure() {
        if (this.mFailure == null) {
            throw new NullPointerException("Not a failure but an error!");
        }
        return this.mFailure;
    }

    public String toString() {
        boolean isFailure = this.isFailure();
        StringBuilder builder = new StringBuilder(64);
        builder.append(this.getClass().getSimpleName());
        builder.append("{isFailure: ");
        builder.append(isFailure);
        builder.append(", errorCode: ");
        builder.append(isFailure ? "NONE" : Integer.valueOf(this.mErrorCode));
        builder.append(", errorBody: ");
        builder.append((Object)(isFailure ? "NONE" : this.mErrorBody));
        builder.append(", failure: ");
        builder.append(isFailure ? this.mFailure : "NONE");
        return builder.append("}").toString();
    }
}

