/*
 * Decompiled with CFR 0.152.
 */
package universum.studios.android.officium.service;

import android.support.annotation.NonNull;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;
import universum.studios.android.officium.service.BaseServiceObject;
import universum.studios.android.officium.service.ServiceError;
import universum.studios.android.officium.service.ServiceObject;

public abstract class ServiceCallback<R>
extends BaseServiceObject
implements Callback<R> {
    public void onResponse(@NonNull Call<R> call, @NonNull Response<R> response) {
        if (response.isSuccessful()) {
            Object responseBody = response.body();
            if (responseBody instanceof ServiceObject) {
                ServiceCallback.associateWith((ServiceObject)responseBody, this.mServiceId, this.mRequestId);
            }
            this.onDispatchResponse(responseBody);
        } else {
            ServiceError error = new ServiceError(response.code(), response.errorBody());
            ServiceCallback.associateWith(error, this.mServiceId, this.mRequestId);
            this.onDispatchError(error);
        }
    }

    protected abstract void onDispatchResponse(@NonNull R var1);

    public void onFailure(@NonNull Call<R> call, @NonNull Throwable failure) {
        ServiceError error = new ServiceError(failure);
        ServiceCallback.associateWith(error, this.mServiceId, this.mRequestId);
        this.onDispatchError(error);
    }

    protected abstract void onDispatchError(@NonNull ServiceError var1);
}

