/*
 * Decompiled with CFR 0.152.
 */
package universum.studios.android.officium.service;

import android.support.annotation.NonNull;
import java.io.IOException;
import okhttp3.Request;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;
import universum.studios.android.officium.service.ServiceCallback;

public class ServiceCall<T>
implements Call<T> {
    private final Call<T> mCall;
    private Integer mServiceId;

    public ServiceCall(@NonNull Call<T> call) {
        this.mCall = call;
    }

    public ServiceCall<T> withServiceId(int serviceId) {
        if (this.mServiceId != null) {
            throw new UnsupportedOperationException("Service id is already specified!");
        }
        this.mServiceId = serviceId;
        return this;
    }

    public Response<T> execute() throws IOException {
        return this.mCall.execute();
    }

    @NonNull
    public String enqueue(@NonNull ServiceCallback<T> callback) {
        String requestId = this.requestId();
        ServiceCallback.associateWith(callback, this.mServiceId, requestId);
        this.enqueue((Callback<T>)callback);
        return requestId;
    }

    @NonNull
    protected String requestId() {
        return Long.toString(System.currentTimeMillis());
    }

    public void enqueue(Callback<T> callback) {
        this.mCall.enqueue(callback);
    }

    public boolean isExecuted() {
        return this.mCall.isExecuted();
    }

    public void cancel() {
        this.mCall.cancel();
    }

    public boolean isCanceled() {
        return this.mCall.isCanceled();
    }

    public Request request() {
        return this.mCall.request();
    }

    public Call<T> clone() {
        ServiceCall<T> serviceCall = new ServiceCall<T>(this.mCall.clone());
        serviceCall.mServiceId = this.mServiceId;
        return serviceCall;
    }
}

