/*
 * Decompiled with CFR 0.152.
 */
package universum.studios.android.officium.account;

import android.accounts.Account;
import android.accounts.AccountManager;
import android.content.Context;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresPermission;
import android.text.TextUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import universum.studios.android.officium.account.UserAccount;
import universum.studios.android.util.ErrorException;

public abstract class UserAccountManager<A extends UserAccount> {
    private static final String TAG = "UserAccountManager";
    public static final int ERROR_CREATE_ACCOUNT = -1;
    public static final int ERROR_DELETE_ACCOUNT = -2;
    protected static final String PERMISSION_GET_ACCOUNTS = "android.permission.GET_ACCOUNTS";
    protected static final String PERMISSION_MANAGE_ACCOUNTS = "android.permission.MANAGE_ACCOUNTS";
    protected static final String PERMISSION_AUTHENTICATE_ACCOUNTS = "android.permission.AUTHENTICATE_ACCOUNTS";
    protected final Context mContext;
    protected final AccountManager mManager;
    protected final String mAccountType;
    private final Handler mUiHandler;
    private final List<AccountWatcher<A>> mWatchers = new ArrayList<AccountWatcher<A>>(5);

    public UserAccountManager(@NonNull Context context, @NonNull String accountType) {
        this.mContext = context;
        this.mManager = AccountManager.get((Context)this.mContext);
        this.mAccountType = accountType;
        this.mUiHandler = new Handler(Looper.getMainLooper());
    }

    public void registerWatcher(@NonNull AccountWatcher<A> watcher) {
        if (!this.mWatchers.contains(watcher)) {
            this.mWatchers.add(watcher);
        }
    }

    public void unregisterWatcher(@NonNull AccountWatcher<A> watcher) {
        this.mWatchers.remove(watcher);
    }

    @RequiresPermission(allOf={"android.permission.GET_ACCOUNTS", "android.permission.AUTHENTICATE_ACCOUNTS"})
    public void createAccountAsync(@NonNull A userAccount) {
        new CreateAccountTask().execute(new UserAccount[]{userAccount});
    }

    @RequiresPermission(allOf={"android.permission.GET_ACCOUNTS", "android.permission.AUTHENTICATE_ACCOUNTS"})
    public boolean createAccount(@NonNull A userAccount) {
        if (this.onCreateAccount(userAccount)) {
            this.mUiHandler.post(new Runnable((UserAccount)userAccount){
                final /* synthetic */ UserAccount val$userAccount;
                {
                    this.val$userAccount = userAccount;
                }

                @Override
                public void run() {
                    UserAccountManager.this.notifyAccountCreated(this.val$userAccount);
                }
            });
            return true;
        }
        return false;
    }

    @RequiresPermission(allOf={"android.permission.GET_ACCOUNTS", "android.permission.AUTHENTICATE_ACCOUNTS"})
    protected boolean onCreateAccount(@NonNull A userAccount) {
        Account account = new Account(((UserAccount)userAccount).getName(), this.mAccountType);
        this.onDeleteAccount(userAccount);
        if (this.mManager.addAccountExplicitly(account, ((UserAccount)userAccount).getPassword(), ((UserAccount)userAccount).getDataBundle())) {
            String[] authTokenTypes = ((UserAccount)userAccount).getAuthTokenTypes();
            Map<String, String> authTokens = ((UserAccount)userAccount).getAuthTokens();
            if (authTokenTypes != null && authTokenTypes.length > 0 && authTokens != null && !authTokens.isEmpty()) {
                for (String authTokenType : authTokenTypes) {
                    this.mManager.setAuthToken(account, authTokenType, authTokens.get(authTokenType));
                }
            }
        }
        return true;
    }

    @RequiresPermission(value="android.permission.AUTHENTICATE_ACCOUNTS")
    public void setAccountAuthToken(@NonNull Account account, @NonNull String authTokenType, @Nullable String authToken) {
        this.mManager.setAuthToken(account, authTokenType, authToken);
    }

    @RequiresPermission(value="android.permission.AUTHENTICATE_ACCOUNTS")
    public boolean isAccountAuthenticated(@NonNull Account account, @NonNull String authTokenType) {
        return !TextUtils.isEmpty((CharSequence)this.peekAccountAuthToken(account, authTokenType));
    }

    @Nullable
    @RequiresPermission(value="android.permission.AUTHENTICATE_ACCOUNTS")
    public String peekAccountAuthToken(@NonNull Account account, @NonNull String authTokenType) {
        return this.mManager.peekAuthToken(account, authTokenType);
    }

    @RequiresPermission(value="android.permission.MANAGE_ACCOUNTS")
    public void invalidateAccountAuthToken(@NonNull Account account, @NonNull String authToken) {
        this.mManager.invalidateAuthToken(account.type, authToken);
    }

    @RequiresPermission(value="android.permission.AUTHENTICATE_ACCOUNTS")
    public void setAccountPassword(@NonNull Account account, @Nullable String password) {
        this.mManager.setPassword(account, password);
    }

    @Nullable
    @RequiresPermission(value="android.permission.AUTHENTICATE_ACCOUNTS")
    public String getAccountPassword(@NonNull Account account) {
        return this.mManager.getPassword(account);
    }

    @RequiresPermission(value="android.permission.MANAGE_ACCOUNTS")
    public void clearAccountPassword(@NonNull Account account) {
        this.mManager.clearPassword(account);
    }

    @RequiresPermission(value="android.permission.AUTHENTICATE_ACCOUNTS")
    public void setAccountData(@NonNull Account account, @NonNull String key, @Nullable String value) {
        this.mManager.setUserData(account, key, value);
    }

    @Nullable
    @RequiresPermission(value="android.permission.AUTHENTICATE_ACCOUNTS")
    public String getAccountData(@NonNull Account account, @NonNull String key) {
        return this.mManager.getUserData(account, key);
    }

    @RequiresPermission(value="android.permission.AUTHENTICATE_ACCOUNTS")
    public void setAccountDataBundle(@NonNull Account account, @NonNull Bundle dataBundle) {
        if (dataBundle.isEmpty()) {
            return;
        }
        for (String key : dataBundle.keySet()) {
            this.mManager.setUserData(account, key, dataBundle.getString(key));
        }
    }

    @NonNull
    @RequiresPermission(value="android.permission.AUTHENTICATE_ACCOUNTS")
    public Bundle getAccountDataBundle(@NonNull Account account, String ... keys) {
        Bundle bundle = new Bundle();
        if (keys.length > 0) {
            for (String key : keys) {
                bundle.putString(key, this.mManager.getUserData(account, key));
            }
        }
        return bundle;
    }

    @RequiresPermission(allOf={"android.permission.GET_ACCOUNTS", "android.permission.AUTHENTICATE_ACCOUNTS"})
    public void deleteAccountAsync(@NonNull A userAccount) {
        new DeleteAccountTask().execute(new UserAccount[]{userAccount});
    }

    @RequiresPermission(allOf={"android.permission.GET_ACCOUNTS", "android.permission.AUTHENTICATE_ACCOUNTS"})
    public boolean deleteAccount(@NonNull A userAccount) {
        if (this.onDeleteAccount(userAccount)) {
            this.mUiHandler.post(new Runnable((UserAccount)userAccount){
                final /* synthetic */ UserAccount val$userAccount;
                {
                    this.val$userAccount = userAccount;
                }

                @Override
                public void run() {
                    UserAccountManager.this.notifyAccountDeleted(this.val$userAccount);
                }
            });
            return true;
        }
        return false;
    }

    @RequiresPermission(allOf={"android.permission.GET_ACCOUNTS", "android.permission.AUTHENTICATE_ACCOUNTS"})
    protected boolean onDeleteAccount(@NonNull A userAccount) {
        Account account = this.findAccountForUser(userAccount);
        if (account != null) {
            if (Build.VERSION.SDK_INT >= 22) {
                this.mManager.removeAccount(account, null, null, null);
            } else {
                this.mManager.removeAccount(account, null, null);
            }
            this.mManager.setPassword(account, null);
            String[] authTokenTypes = ((UserAccount)userAccount).getAuthTokenTypes();
            if (authTokenTypes != null && authTokenTypes.length > 0) {
                for (String authTokenType : authTokenTypes) {
                    this.mManager.invalidateAuthToken(account.type, this.mManager.peekAuthToken(account, authTokenType));
                }
            }
            return true;
        }
        return false;
    }

    @Nullable
    @RequiresPermission(value="android.permission.GET_ACCOUNTS")
    protected Account findAccountForUser(@NonNull A userAccount) {
        Account[] accounts = this.mManager.getAccountsByType(this.mAccountType);
        if (accounts.length > 0) {
            String accountName = ((UserAccount)userAccount).getName();
            for (Account account : accounts) {
                if (!account.name.equals(accountName)) continue;
                return account;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void notifyAccountCreated(@NonNull A userAccount) {
        List<AccountWatcher<A>> list = this.mWatchers;
        synchronized (list) {
            if (!this.mWatchers.isEmpty()) {
                for (AccountWatcher<A> watcher : this.mWatchers) {
                    watcher.onAccountCreated(userAccount);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void notifyAccountDeleted(@NonNull A userAccount) {
        List<AccountWatcher<A>> list = this.mWatchers;
        synchronized (list) {
            if (!this.mWatchers.isEmpty()) {
                for (AccountWatcher<A> watcher : this.mWatchers) {
                    watcher.onAccountDeleted(userAccount);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void notifyAccountError(@NonNull A userAccount, @NonNull ErrorException error) {
        List<AccountWatcher<A>> list = this.mWatchers;
        synchronized (list) {
            if (!this.mWatchers.isEmpty()) {
                for (AccountWatcher<A> watcher : this.mWatchers) {
                    watcher.onAccountError(userAccount, error);
                }
            }
        }
    }

    private static final class TaskResult<A extends UserAccount> {
        final A account;
        final ErrorException error;

        TaskResult(A account, ErrorException error) {
            this.account = account;
            this.error = error;
        }
    }

    private final class DeleteAccountTask
    extends AsyncTask<A, Void, TaskResult<A>> {
        private DeleteAccountTask() {
        }

        @SafeVarargs
        protected final TaskResult<A> doInBackground(A ... accounts) {
            Object account = accounts[0];
            ErrorException error = null;
            try {
                if (!UserAccountManager.this.onDeleteAccount(account)) {
                    error = ErrorException.withCode((int)-2);
                }
            }
            catch (Exception e) {
                error = new ErrorException(-2, (Throwable)e);
            }
            return new TaskResult(account, error);
        }

        protected final void onPostExecute(@NonNull TaskResult<A> result) {
            if (result.error == null) {
                UserAccountManager.this.notifyAccountDeleted(result.account);
            } else {
                UserAccountManager.this.notifyAccountError(result.account, result.error);
            }
        }
    }

    private final class CreateAccountTask
    extends AsyncTask<A, Void, TaskResult<A>> {
        private CreateAccountTask() {
        }

        @SafeVarargs
        protected final TaskResult<A> doInBackground(A ... accounts) {
            Object account = accounts[0];
            ErrorException error = null;
            try {
                if (!UserAccountManager.this.onCreateAccount(account)) {
                    error = ErrorException.withCode((int)-1);
                }
            }
            catch (Exception e) {
                error = new ErrorException(-1, (Throwable)e);
            }
            return new TaskResult(account, error);
        }

        protected final void onPostExecute(@NonNull TaskResult<A> result) {
            if (result.error == null) {
                UserAccountManager.this.notifyAccountCreated(result.account);
            } else {
                UserAccountManager.this.notifyAccountError(result.account, result.error);
            }
        }
    }

    public static interface AccountWatcher<A extends UserAccount> {
        public void onAccountCreated(@NonNull A var1);

        public void onAccountDeleted(@NonNull A var1);

        public void onAccountError(@NonNull A var1, @NonNull ErrorException var2);
    }
}

