/*
 * Decompiled with CFR 0.152.
 */
package universum.studios.android.officium.account;

import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import java.util.HashMap;
import java.util.Map;

public class UserAccount {
    public static final String TOKEN_TYPE_O_AUTH = "oAuth";
    protected static final String[] AUTH_TOKEN_TYPES = new String[]{"oAuth"};
    protected final String mName;
    protected String mPassword;
    private Map<String, String> mAuthTokens;
    private Bundle mDataBundle;

    public UserAccount(@NonNull String name) {
        this(name, null);
    }

    public UserAccount(@NonNull String name, @Nullable String password) {
        this.mName = name;
        this.mPassword = password;
    }

    @NonNull
    public final String getName() {
        return this.mName;
    }

    public final void setPassword(@Nullable String password) {
        this.mPassword = password;
    }

    @Nullable
    public final String getPassword() {
        return this.mPassword;
    }

    public void putData(@NonNull String key, @Nullable String data) {
        if (this.mDataBundle == null) {
            this.mDataBundle = new Bundle();
        }
        this.mDataBundle.putString(key, data);
    }

    public boolean hasData(@NonNull String key) {
        return this.mDataBundle != null && this.mDataBundle.containsKey(key);
    }

    @Nullable
    public String getData(@NonNull String key) {
        return this.mDataBundle != null ? this.mDataBundle.getString(key) : null;
    }

    public void removeData(@NonNull String key) {
        if (this.mDataBundle != null) {
            this.mDataBundle.remove(key);
        }
    }

    public void setDataBundle(@Nullable Bundle dataBundle) {
        this.mDataBundle = dataBundle;
    }

    @Nullable
    public Bundle getDataBundle() {
        return this.mDataBundle;
    }

    public void putOAuthToken(@Nullable String authToken) {
        this.putAuthToken(TOKEN_TYPE_O_AUTH, authToken);
    }

    public void putAuthToken(@Nullable String tokenType, @Nullable String token) {
        if (this.mAuthTokens == null) {
            this.mAuthTokens = new HashMap<String, String>(1);
        }
        this.mAuthTokens.put(tokenType, token);
    }

    public boolean hasAuthToken(@Nullable String tokenType) {
        return this.mAuthTokens != null && this.mAuthTokens.containsKey(tokenType);
    }

    @Nullable
    public String getOAuthToken() {
        return this.getAuthToken(TOKEN_TYPE_O_AUTH);
    }

    @Nullable
    public String getAuthToken(@Nullable String tokenType) {
        return this.mAuthTokens != null ? this.mAuthTokens.get(tokenType) : null;
    }

    @Nullable
    protected String[] getAuthTokenTypes() {
        return AUTH_TOKEN_TYPES;
    }

    @Nullable
    protected Map<String, String> getAuthTokens() {
        return this.mAuthTokens;
    }

    public int hashCode() {
        return this.mName != null ? this.mName.hashCode() : 0;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof UserAccount)) {
            return false;
        }
        UserAccount account = (UserAccount)other;
        return TextUtils.equals((CharSequence)account.mName, (CharSequence)this.mName);
    }
}

