/*
 * Decompiled with CFR 0.152.
 */
package universum.studios.android.officium.account;

import android.accounts.Account;
import android.accounts.AccountManager;
import android.content.Context;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresPermission;
import universum.studios.android.officium.account.UserAccount;
import universum.studios.android.officium.account.UserAccountManager;

public class SingleUserAccountManager<A extends UserAccount>
extends UserAccountManager<A> {
    public SingleUserAccountManager(@NonNull Context context, @NonNull String accountType) {
        super(context, accountType);
    }

    @RequiresPermission(value="android.permission.GET_ACCOUNTS")
    public boolean isAccountCreated() {
        return this.acquireAccount() != null;
    }

    @Nullable
    @RequiresPermission(value="android.permission.GET_ACCOUNTS")
    public Account getAccount() {
        return this.acquireAccount();
    }

    @RequiresPermission(allOf={"android.permission.GET_ACCOUNTS", "android.permission.AUTHENTICATE_ACCOUNTS"})
    public boolean setAccountAuthToken(@NonNull String authTokenType, @Nullable String authToken) {
        Account account = this.acquireAccount();
        if (account == null) {
            return false;
        }
        this.setAccountAuthToken(account, authTokenType, authToken);
        return true;
    }

    @RequiresPermission(allOf={"android.permission.GET_ACCOUNTS", "android.permission.AUTHENTICATE_ACCOUNTS"})
    public boolean isAccountAuthenticated(@NonNull String authTokenType) {
        Account account = this.acquireAccount();
        return account != null && this.isAccountAuthenticated(account, authTokenType);
    }

    @Nullable
    @RequiresPermission(allOf={"android.permission.GET_ACCOUNTS", "android.permission.AUTHENTICATE_ACCOUNTS"})
    public String peekAccountAuthToken(@NonNull String authTokenType) {
        Account account = this.acquireAccount();
        return account != null ? this.peekAccountAuthToken(account, authTokenType) : null;
    }

    @RequiresPermission(allOf={"android.permission.GET_ACCOUNTS", "android.permission.MANAGE_ACCOUNTS"})
    public boolean invalidateAccountAuthToken(@NonNull String authToken) {
        Account account = this.acquireAccount();
        if (account == null) {
            return false;
        }
        this.invalidateAccountAuthToken(account, authToken);
        return true;
    }

    @RequiresPermission(allOf={"android.permission.GET_ACCOUNTS", "android.permission.AUTHENTICATE_ACCOUNTS"})
    public boolean setAccountPassword(@Nullable String password) {
        Account account = this.acquireAccount();
        if (account == null) {
            return false;
        }
        this.setAccountPassword(account, password);
        return true;
    }

    @Nullable
    @RequiresPermission(allOf={"android.permission.GET_ACCOUNTS", "android.permission.AUTHENTICATE_ACCOUNTS"})
    public String getAccountPassword() {
        Account account = this.acquireAccount();
        return account != null ? this.getAccountPassword(account) : null;
    }

    @RequiresPermission(allOf={"android.permission.GET_ACCOUNTS", "android.permission.MANAGE_ACCOUNTS"})
    public boolean clearAccountPassword() {
        Account account = this.acquireAccount();
        if (account == null) {
            return false;
        }
        this.clearAccountPassword(account);
        return true;
    }

    @RequiresPermission(allOf={"android.permission.GET_ACCOUNTS", "android.permission.AUTHENTICATE_ACCOUNTS"})
    public boolean setAccountData(@NonNull String key, @Nullable String value) {
        Account account = this.acquireAccount();
        if (account == null) {
            return false;
        }
        this.setAccountData(account, key, value);
        return true;
    }

    @Nullable
    @RequiresPermission(allOf={"android.permission.GET_ACCOUNTS", "android.permission.AUTHENTICATE_ACCOUNTS"})
    public String getAccountData(@NonNull String key) {
        Account account = this.acquireAccount();
        return account != null ? this.getAccountData(account, key) : null;
    }

    @RequiresPermission(allOf={"android.permission.GET_ACCOUNTS", "android.permission.AUTHENTICATE_ACCOUNTS"})
    public boolean setAccountDataBundle(@NonNull Bundle dataBundle) {
        Account account = this.acquireAccount();
        if (account == null) {
            return false;
        }
        this.setAccountDataBundle(account, dataBundle);
        return true;
    }

    @Nullable
    @RequiresPermission(allOf={"android.permission.GET_ACCOUNTS", "android.permission.AUTHENTICATE_ACCOUNTS"})
    public Bundle getAccountDataBundle(String ... keys) {
        Account account = this.acquireAccount();
        return account != null ? this.getAccountDataBundle(account, keys) : null;
    }

    @Nullable
    @RequiresPermission(value="android.permission.GET_ACCOUNTS")
    protected Account acquireAccount() {
        AccountManager manager = AccountManager.get((Context)this.mContext);
        Account[] accounts = manager.getAccountsByType(this.mAccountType);
        return accounts.length > 0 ? accounts[0] : null;
    }
}

