/*
 * Decompiled with CFR 0.152.
 */
package universum.studios.android.logging;

import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import universum.studios.android.logging.Logger;

public class SimpleLogger
implements Logger {
    private int logLevel;

    public SimpleLogger(int level) {
        this.logLevel = level;
    }

    @Override
    public void setLogLevel(int level) {
        this.logLevel = level;
    }

    @Override
    public int getLogLevel() {
        return this.logLevel;
    }

    @Override
    public boolean isLoggable(@NonNull String tag, int level) {
        return this.logLevel <= level;
    }

    @Override
    public void d(@NonNull String tag, @NonNull String message) {
        if (this.isLoggable(tag, 3)) {
            Log.d((String)tag, (String)message);
        }
    }

    @Override
    public void d(@NonNull String tag, @NonNull String message, @Nullable Throwable throwable) {
        if (this.isLoggable(tag, 3)) {
            Log.d((String)tag, (String)message, (Throwable)throwable);
        }
    }

    @Override
    public void v(@NonNull String tag, @NonNull String message) {
        if (this.isLoggable(tag, 2)) {
            Log.v((String)tag, (String)message);
        }
    }

    @Override
    public void v(@NonNull String tag, @NonNull String message, @Nullable Throwable throwable) {
        if (this.isLoggable(tag, 2)) {
            Log.v((String)tag, (String)message, (Throwable)throwable);
        }
    }

    @Override
    public void i(@NonNull String tag, @NonNull String message) {
        if (this.isLoggable(tag, 4)) {
            Log.i((String)tag, (String)message);
        }
    }

    @Override
    public void i(@NonNull String tag, @NonNull String message, @Nullable Throwable throwable) {
        if (this.isLoggable(tag, 4)) {
            Log.i((String)tag, (String)message, (Throwable)throwable);
        }
    }

    @Override
    public void w(@NonNull String tag, @NonNull String message) {
        if (this.isLoggable(tag, 5)) {
            Log.w((String)tag, (String)message);
        }
    }

    @Override
    public void w(@NonNull String tag, @Nullable Throwable throwable) {
        if (this.isLoggable(tag, 5)) {
            Log.w((String)tag, (Throwable)throwable);
        }
    }

    @Override
    public void w(@NonNull String tag, @NonNull String message, @Nullable Throwable throwable) {
        if (this.isLoggable(tag, 5)) {
            Log.w((String)tag, (String)message, (Throwable)throwable);
        }
    }

    @Override
    public void e(@NonNull String tag, @NonNull String message) {
        if (this.isLoggable(tag, 6)) {
            Log.e((String)tag, (String)message);
        }
    }

    @Override
    public void e(@NonNull String tag, @NonNull String message, @Nullable Throwable throwable) {
        if (this.isLoggable(tag, 6)) {
            Log.e((String)tag, (String)message, (Throwable)throwable);
        }
    }

    @Override
    public void wtf(@NonNull String tag, @NonNull String message) {
        Log.wtf((String)tag, (String)message);
    }

    @Override
    public void wtf(@NonNull String tag, @Nullable Throwable throwable) {
        Log.wtf((String)tag, (Throwable)throwable);
    }

    @Override
    public void wtf(@NonNull String tag, @NonNull String message, @Nullable Throwable throwable) {
        Log.wtf((String)tag, (String)message, (Throwable)throwable);
    }

    @Override
    public void log(int level, @NonNull String tag, @NonNull String message) {
        if (this.isLoggable(tag, level)) {
            this.forceLog(level, tag, message);
        }
    }

    @Override
    public void forceLog(int level, @NonNull String tag, @NonNull String message) {
        Log.println((int)level, (String)tag, (String)message);
    }

    @Override
    @Nullable
    public String getStackTraceString(@Nullable Throwable throwable) {
        return Log.getStackTraceString((Throwable)throwable);
    }
}

