/*
 * Decompiled with CFR 0.152.
 */
package universum.studios.android.intent;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import universum.studios.android.intent.BaseIntent;
import universum.studios.android.intent.IntentStarter;

public class SimpleIntent
extends BaseIntent<SimpleIntent> {
    private static final int TYPE_ACTIVITY = 1;
    private static final int TYPE_ACTION = 2;
    private int type;
    private String action;
    private Class<? extends Activity> activityClass;
    private int flags;
    private int requestCode = -1;
    private boolean forResult;

    public SimpleIntent activityClass(@NonNull Class<? extends Activity> activityClass) {
        this.activityClass = activityClass;
        this.type = 1;
        return this;
    }

    @Nullable
    public Class<? extends Activity> activityClass() {
        return this.activityClass;
    }

    public SimpleIntent action(@NonNull String action) {
        this.action = action;
        this.type = 2;
        return this;
    }

    @NonNull
    public String action() {
        return this.action == null ? "" : this.action;
    }

    public SimpleIntent flags(@IntRange(from=0L, to=0x7FFFFFFFL) int flags) {
        this.flags = flags;
        return this;
    }

    public SimpleIntent flag(@IntRange(from=1L, to=0x7FFFFFFFL) int flag) {
        this.flags |= flag;
        return this;
    }

    @IntRange(from=0L, to=0x7FFFFFFFL)
    public int flags() {
        return this.flags;
    }

    public SimpleIntent requestCode(int requestCode) {
        this.requestCode = requestCode;
        this.forResult = this.requestCode >= 0;
        return this;
    }

    public int requestCode() {
        return this.requestCode;
    }

    @Override
    protected void ensureCanBuildOrThrow() {
        super.ensureCanBuildOrThrow();
        switch (this.type) {
            case 1: {
                if (this.activityClass != null) break;
                throw this.cannotBuildIntentException("No activity class specified.");
            }
            case 2: {
                if (this.action != null) break;
                throw this.cannotBuildIntentException("No action specified.");
            }
            default: {
                throw this.cannotBuildIntentException("No activity class or action specified.");
            }
        }
    }

    @Override
    @NonNull
    protected Intent onBuild(@NonNull Context context) {
        switch (this.type) {
            case 2: {
                return new Intent(this.action).setFlags(this.flags);
            }
        }
        return new Intent(context, this.activityClass).setFlags(this.flags);
    }

    @Override
    protected boolean onStartWith(@NonNull IntentStarter starter, @NonNull Intent intent) {
        if (this.forResult) {
            starter.startIntentForResult(intent, this.requestCode);
        } else {
            starter.startIntent(intent);
        }
        return true;
    }
}

