/*
 * Decompiled with CFR 0.152.
 */
package universum.studios.android.intent;

import android.app.Activity;
import android.app.Fragment;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import androidx.annotation.AnimRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import universum.studios.android.intent.IntentStarter;

public final class IntentStarters {
    private IntentStarters() {
        throw new UnsupportedOperationException();
    }

    @NonNull
    public static IntentStarter activityStarter(@NonNull Activity activity) {
        return new ActivityStarter(activity);
    }

    public static IntentStarter fragmentStarter(@NonNull Fragment fragment) {
        return new FragmentStarter(fragment);
    }

    public static IntentStarter supportFragmentStarter(@NonNull androidx.fragment.app.Fragment fragment) {
        return new SupportFragmentStarter(fragment);
    }

    private static final class SupportFragmentStarter
    implements IntentStarter {
        private final androidx.fragment.app.Fragment fragment;

        SupportFragmentStarter(androidx.fragment.app.Fragment fragment) {
            this.fragment = fragment;
        }

        @Override
        @NonNull
        public Context getContext() {
            return this.fragment.requireActivity();
        }

        @Override
        public void startIntent(@NonNull Intent intent) {
            this.fragment.startActivity(intent);
        }

        @Override
        public void startIntent(@NonNull Intent intent, @Nullable Bundle options) {
            this.fragment.startActivity(intent, options);
        }

        @Override
        public void startIntentForResult(@NonNull Intent intent, int requestCode) {
            this.fragment.startActivityForResult(intent, requestCode);
        }

        @Override
        public void startIntentForResult(@NonNull Intent intent, int requestCode, @Nullable Bundle options) {
            this.fragment.startActivityForResult(intent, requestCode, options);
        }

        @Override
        public void overridePendingTransition(@AnimRes int enterAnimRes, @AnimRes int exitAnimRes) {
            this.fragment.requireActivity().overridePendingTransition(enterAnimRes, exitAnimRes);
        }
    }

    private static final class FragmentStarter
    implements IntentStarter {
        private final Fragment fragment;

        FragmentStarter(Fragment fragment) {
            this.fragment = fragment;
        }

        @Override
        @NonNull
        public Context getContext() {
            return this.fragment.getActivity();
        }

        @Override
        public void startIntent(@NonNull Intent intent) {
            this.fragment.startActivity(intent);
        }

        @Override
        public void startIntent(@NonNull Intent intent, @Nullable Bundle options) {
            if (Build.VERSION.SDK_INT >= 16) {
                this.fragment.startActivity(intent, options);
            }
        }

        @Override
        public void startIntentForResult(@NonNull Intent intent, int requestCode) {
            this.fragment.startActivityForResult(intent, requestCode);
        }

        @Override
        public void startIntentForResult(@NonNull Intent intent, int requestCode, @Nullable Bundle options) {
            if (Build.VERSION.SDK_INT >= 16) {
                this.fragment.startActivityForResult(intent, requestCode, options);
            }
        }

        @Override
        public void overridePendingTransition(@AnimRes int enterAnimRes, @AnimRes int exitAnimRes) {
            this.fragment.getActivity().overridePendingTransition(enterAnimRes, exitAnimRes);
        }
    }

    private static final class ActivityStarter
    implements IntentStarter {
        private final Activity activity;

        ActivityStarter(Activity activity) {
            this.activity = activity;
        }

        @Override
        @NonNull
        public Context getContext() {
            return this.activity;
        }

        @Override
        public void startIntent(@NonNull Intent intent) {
            this.activity.startActivity(intent);
        }

        @Override
        public void startIntent(@NonNull Intent intent, @Nullable Bundle options) {
            if (Build.VERSION.SDK_INT >= 16) {
                this.activity.startActivity(intent, options);
            }
        }

        @Override
        public void startIntentForResult(@NonNull Intent intent, int requestCode) {
            this.activity.startActivityForResult(intent, requestCode);
        }

        @Override
        public void startIntentForResult(@NonNull Intent intent, int requestCode, @Nullable Bundle options) {
            if (Build.VERSION.SDK_INT >= 16) {
                this.activity.startActivityForResult(intent, requestCode, options);
            }
        }

        @Override
        public void overridePendingTransition(@AnimRes int enterAnimRes, @AnimRes int exitAnimRes) {
            this.activity.overridePendingTransition(enterAnimRes, exitAnimRes);
        }
    }
}

