/*
 * Decompiled with CFR 0.152.
 */
package universum.studios.android.intent;

import android.content.ContentUris;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.provider.CalendarContract;
import android.text.TextUtils;
import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import universum.studios.android.intent.BaseIntent;

public class CalendarIntent
extends BaseIntent<CalendarIntent> {
    public static final int TYPE_VIEW = 1;
    public static final int TYPE_INSERT_EVENT = 2;
    public static final int TYPE_EDIT_EVENT = 3;
    public static final int TYPE_VIEW_EVENT = 4;
    public static final int AVAILABILITY_BUSY = 0;
    public static final int AVAILABILITY_FREE = 1;
    public static final int AVAILABILITY_TENTATIVE = 2;
    private int type = 1;
    private long eventId = -1L;
    private long beginTime = System.currentTimeMillis();
    private long endTime = this.beginTime + 1L;
    private CharSequence title;
    private CharSequence description;
    private CharSequence location;
    private int availability = 0;

    public CalendarIntent type(int type) {
        this.type = type;
        return this;
    }

    public int type() {
        return this.type;
    }

    public CalendarIntent eventId(@IntRange(from=1L) long eventId) {
        this.eventId = eventId;
        return this;
    }

    public long eventId() {
        return this.eventId;
    }

    public CalendarIntent time(@IntRange(from=0L) long time) {
        this.beginTime = time;
        return this;
    }

    public long time() {
        return this.beginTime;
    }

    public CalendarIntent beginTime(@IntRange(from=0L) long beginTime) {
        this.beginTime = beginTime;
        return this;
    }

    public long beginTime() {
        return this.beginTime;
    }

    public CalendarIntent endTime(@IntRange(from=0L) long endTime) {
        this.endTime = endTime;
        return this;
    }

    public long endTime() {
        return this.endTime;
    }

    public CalendarIntent title(@Nullable CharSequence title) {
        this.title = title;
        return this;
    }

    @NonNull
    public CharSequence title() {
        return this.title == null ? "" : this.title;
    }

    public CalendarIntent description(@Nullable CharSequence description) {
        this.description = description;
        return this;
    }

    @NonNull
    public CharSequence description() {
        return this.description == null ? "" : this.description;
    }

    public CalendarIntent location(@Nullable CharSequence location) {
        this.location = location;
        return this;
    }

    @NonNull
    public CharSequence location() {
        return this.location == null ? "" : this.location;
    }

    public CalendarIntent availability(int availability) {
        this.availability = availability;
        return this;
    }

    public int availability() {
        return this.availability;
    }

    @Override
    protected void ensureCanBuildOrThrow() {
        super.ensureCanBuildOrThrow();
        switch (this.type) {
            case 1: {
                if (this.beginTime >= 0L) break;
                throw this.cannotBuildIntentException("Specified invalid time(" + this.beginTime + ") where to open calendar for view. Must be none-negative time value.");
            }
            case 2: {
                if (this.beginTime < 0L) {
                    throw this.cannotBuildIntentException("Specified invalid begin time(" + this.beginTime + "). Must be none-negative time value.");
                }
                if (this.endTime < 0L) {
                    throw this.cannotBuildIntentException("Specified invalid end time(" + this.endTime + "). Must be none-negative time value.");
                }
                if (this.endTime > this.beginTime) break;
                throw this.cannotBuildIntentException("Specified end time(" + this.endTime + ") is before/at begin time(" + this.beginTime + "). Must be greater than the begin time.");
            }
            default: {
                if (this.eventId > 0L) break;
                throw this.cannotBuildIntentException("Specified invalid event id(" + this.eventId + ").");
            }
        }
    }

    @Override
    @NonNull
    protected Intent onBuild(@NonNull Context context) {
        switch (this.type) {
            case 1: {
                Uri.Builder builder = CalendarContract.CONTENT_URI.buildUpon();
                builder.appendPath("time");
                ContentUris.appendId((Uri.Builder)builder, (long)this.beginTime);
                return new Intent("android.intent.action.VIEW").setData(builder.build());
            }
            case 2: {
                return new Intent("android.intent.action.INSERT").setData(CalendarContract.Events.CONTENT_URI).putExtra("beginTime", this.beginTime).putExtra("endTime", this.endTime).putExtra("title", this.title).putExtra("description", this.description).putExtra("eventLocation", this.location).putExtra("availability", this.availability);
            }
            case 3: {
                Intent intent = new Intent("android.intent.action.EDIT");
                intent.setData(ContentUris.withAppendedId((Uri)CalendarContract.Events.CONTENT_URI, (long)this.eventId));
                if (!TextUtils.isEmpty((CharSequence)this.title)) {
                    intent.putExtra("title", this.title);
                }
                return intent;
            }
        }
        return new Intent("android.intent.action.VIEW").setData(ContentUris.withAppendedId((Uri)CalendarContract.Events.CONTENT_URI, (long)this.eventId));
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Availability {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Type {
    }
}

