/*
 * Decompiled with CFR 0.152.
 */
package universum.studios.android.intent;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import universum.studios.android.intent.BaseIntent;

public final class SmsIntent
extends BaseIntent {
    public static final String URI_SCHEME = "sms";
    private String phoneNumber;
    private CharSequence body;

    public SmsIntent phoneNumber(@Nullable String number) {
        this.phoneNumber = number;
        return this;
    }

    @NonNull
    public String phoneNumber() {
        return this.phoneNumber == null ? "" : this.phoneNumber;
    }

    public SmsIntent body(@Nullable CharSequence body) {
        this.body = body;
        return this;
    }

    @NonNull
    public CharSequence body() {
        return this.body == null ? "" : this.body;
    }

    @Override
    protected void ensureCanBuildOrThrow() {
        super.ensureCanBuildOrThrow();
        if (TextUtils.isEmpty((CharSequence)this.phoneNumber)) {
            throw this.cannotBuildIntentException("No phone number specified.");
        }
    }

    @Override
    @NonNull
    protected Intent onBuild(@NonNull Context context) {
        Intent intent = new Intent("android.intent.action.VIEW", Uri.fromParts((String)URI_SCHEME, (String)this.phoneNumber, null));
        if (!TextUtils.isEmpty((CharSequence)this.body)) {
            intent.putExtra("sms_body", this.body);
        }
        return intent;
    }
}

