/*
 * Decompiled with CFR 0.152.
 */
package universum.studios.android.intent;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.text.TextUtils;
import androidx.annotation.FloatRange;
import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import universum.studios.android.intent.BaseIntent;

public class MapIntent
extends BaseIntent<MapIntent> {
    public static final String URI_SCHEME = "geo";
    public static final double LAT_MIN = -90.0;
    public static final double LAT_MAX = 90.0;
    public static final double LNG_MIN = -180.0;
    public static final double LNG_MAX = 180.0;
    public static final int ZOOM_LEVEL_MIN = 1;
    public static final int ZOOM_LEVEL_MAX = 23;
    private double lng;
    private double lat;
    private boolean latLngSet;
    private int zoomLevel;
    private String label;
    private String locationQuery;

    public MapIntent location(@FloatRange(from=-90.0, to=90.0) double lat, @FloatRange(from=-180.0, to=180.0) double lng) {
        this.lat = Math.max(-90.0, Math.min(90.0, lat));
        this.lng = Math.max(-180.0, Math.min(180.0, lng));
        this.latLngSet = true;
        return this;
    }

    @FloatRange(from=-90.0, to=90.0)
    public double lat() {
        return this.lat;
    }

    @FloatRange(from=-180.0, to=180.0)
    public double lng() {
        return this.lng;
    }

    public MapIntent locationQuery(@Nullable String query) {
        this.locationQuery = query;
        return this;
    }

    @NonNull
    public String locationQuery() {
        return this.locationQuery == null ? "" : this.locationQuery;
    }

    public MapIntent zoomLevel(@IntRange(from=1L, to=23L) int level) {
        this.zoomLevel = Math.max(1, Math.min(23, level));
        return this;
    }

    @IntRange(from=0L, to=23L)
    public int zoomLevel() {
        return this.zoomLevel;
    }

    public MapIntent label(@Nullable String label) {
        this.label = label;
        return this;
    }

    @NonNull
    public String label() {
        return this.label == null ? "" : this.label;
    }

    @Override
    protected void ensureCanBuildOrThrow() {
        super.ensureCanBuildOrThrow();
        if (!this.latLngSet && TextUtils.isEmpty((CharSequence)this.locationQuery)) {
            throw this.cannotBuildIntentException("No latitude and longitude nor location query specified.");
        }
    }

    @Override
    @NonNull
    protected Intent onBuild(@NonNull Context context) {
        StringBuilder uriBuilder = new StringBuilder(64);
        if (this.latLngSet) {
            if (TextUtils.isEmpty((CharSequence)this.label)) {
                uriBuilder.append(this.lat);
                uriBuilder.append(",");
                uriBuilder.append(this.lng);
                if (this.zoomLevel != 0) {
                    uriBuilder.append("?z=");
                    uriBuilder.append(this.zoomLevel);
                }
                if (!TextUtils.isEmpty((CharSequence)this.locationQuery)) {
                    uriBuilder.append(this.zoomLevel == 0 ? "?" : "&");
                    this.appendLocationQuery(uriBuilder);
                }
            } else {
                uriBuilder.append("0,0?q=");
                uriBuilder.append(this.lat);
                uriBuilder.append(",");
                uriBuilder.append(this.lng);
                this.appendLabel(uriBuilder);
            }
        } else {
            uriBuilder.append("0,0?");
            this.appendLocationQuery(uriBuilder);
            if (!TextUtils.isEmpty((CharSequence)this.label)) {
                this.appendLabel(uriBuilder);
            }
        }
        return new Intent("android.intent.action.VIEW", Uri.parse((String)("geo:" + uriBuilder.toString())));
    }

    private void appendLocationQuery(StringBuilder uriBuilder) {
        uriBuilder.append("q=").append(Uri.encode((String)this.locationQuery));
    }

    private void appendLabel(StringBuilder uriBuilder) {
        uriBuilder.append("(").append(Uri.encode((String)this.label)).append(")");
    }
}

