/*
 * Decompiled with CFR 0.152.
 */
package universum.studios.android.intent;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.support.annotation.NonNull;
import android.support.annotation.VisibleForTesting;
import android.text.TextUtils;
import android.util.Patterns;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import universum.studios.android.intent.BaseIntent;

public class WebIntent
extends BaseIntent<WebIntent> {
    public static final Matcher WEB_URL_MATCHER = Patterns.WEB_URL.matcher("");
    @VisibleForTesting
    static final String HTTP_PREFIX = "http://";
    @VisibleForTesting
    static final Matcher HTTP_FORMAT_MATCHER = Pattern.compile("^(http|https):\\/\\/(.+)").matcher("");
    private String url;

    public WebIntent url(@NonNull String url) {
        if (WEB_URL_MATCHER.reset(url).matches()) {
            this.url = HTTP_FORMAT_MATCHER.reset(url).matches() ? url : HTTP_PREFIX + url;
        }
        return this;
    }

    @NonNull
    public String url() {
        return this.url == null ? "" : this.url;
    }

    @Override
    protected void ensureCanBuildOrThrow() {
        super.ensureCanBuildOrThrow();
        if (TextUtils.isEmpty((CharSequence)this.url)) {
            throw this.cannotBuildIntentException("No or invalid URL specified.");
        }
    }

    @Override
    @NonNull
    protected Intent onBuild(@NonNull Context context) {
        return new Intent("android.intent.action.VIEW", Uri.parse((String)this.url));
    }
}

