/*
 * Decompiled with CFR 0.152.
 */
package universum.studios.android.intent;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import universum.studios.android.intent.BaseIntent;
import universum.studios.android.intent.IntentStarter;

public class ShareIntent
extends BaseIntent<ShareIntent> {
    private String dataType = "text/*";
    private CharSequence title;
    private CharSequence content;
    private Uri uri;
    private List<Uri> uris;

    public ShareIntent content(@Nullable CharSequence text) {
        this.content = text;
        return this;
    }

    @NonNull
    public CharSequence content() {
        return this.content == null ? "" : this.content;
    }

    public ShareIntent uri(@Nullable Uri uri) {
        this.uri = uri;
        return this;
    }

    @Nullable
    public Uri uri() {
        return this.uri;
    }

    public ShareIntent uris(Uri ... uris) {
        return this.uris(Arrays.asList(uris));
    }

    public ShareIntent uris(@Nullable List<Uri> uris) {
        this.uris = uris;
        return this;
    }

    @NonNull
    public List<Uri> uris() {
        return this.uris == null ? Collections.emptyList() : new ArrayList<Uri>(this.uris);
    }

    public ShareIntent mimeType(@NonNull String type) {
        this.dataType = type;
        return this;
    }

    @NonNull
    public String mimeType() {
        return this.dataType;
    }

    public ShareIntent title(@Nullable CharSequence title) {
        this.title = title;
        return this;
    }

    @NonNull
    public CharSequence title() {
        return this.title == null ? "" : this.title;
    }

    @Override
    protected void ensureCanBuildOrThrow() {
        super.ensureCanBuildOrThrow();
        if (TextUtils.isEmpty((CharSequence)this.content) && this.uri == null && this.uris == null) {
            throw this.cannotBuildIntentException("No content to share specified.");
        }
        if (TextUtils.isEmpty((CharSequence)this.dataType)) {
            throw this.cannotBuildIntentException("No content's MIME type specified.");
        }
    }

    @Override
    @NonNull
    protected Intent onBuild(@NonNull Context context) {
        Intent intent = new Intent("android.intent.action.SEND");
        intent.setType(this.dataType);
        if (!TextUtils.isEmpty((CharSequence)this.title)) {
            intent.putExtra("android.intent.extra.TITLE", this.title);
        }
        if (!TextUtils.isEmpty((CharSequence)this.content)) {
            intent.putExtra("android.intent.extra.TEXT", this.content);
        }
        if (this.uri != null) {
            intent.putExtra("android.intent.extra.STREAM", (Parcelable)this.uri);
        } else if (this.uris != null) {
            intent.setAction("android.intent.action.SEND_MULTIPLE");
            intent.putParcelableArrayListExtra("android.intent.extra.STREAM", new ArrayList<Uri>(this.uris));
        }
        return intent;
    }

    @Override
    protected boolean onStartWith(@NonNull IntentStarter starter, @NonNull Intent intent) {
        return super.onStartWith(starter, Intent.createChooser((Intent)intent, (CharSequence)this.dialogTitle));
    }
}

