/*
 * Decompiled with CFR 0.152.
 */
package universum.studios.android.intent;

import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.os.Bundle;
import android.os.Environment;
import android.os.Parcelable;
import android.support.annotation.IntRange;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import universum.studios.android.intent.ContentIntent;

public class ImageIntent
extends ContentIntent<ImageIntent> {
    private static final String TAG = "ImageIntent";
    public static final int REQUEST_CODE_GALLERY = 20481;
    public static final int REQUEST_CODE_CAMERA = 20482;
    public static final String IMAGE_FILE_NAME_FORMAT = "IMAGE_%s";
    private ContentIntent.ContentHandler cameraHandler;

    @NonNull
    public static Intent createGalleryIntent() {
        return new Intent("android.intent.action.GET_CONTENT").setType("image/*");
    }

    @NonNull
    public static Intent createCameraIntent() {
        return ImageIntent.createCameraIntent((Uri)null);
    }

    @NonNull
    public static Intent createCameraIntent(@Nullable File outputFile) {
        return ImageIntent.createCameraIntent(outputFile == null ? null : Uri.fromFile((File)outputFile));
    }

    @NonNull
    public static Intent createCameraIntent(@Nullable Uri outputUri) {
        Intent intent = new Intent("android.media.action.IMAGE_CAPTURE");
        if (outputUri != null) {
            intent.putExtra("output", (Parcelable)outputUri);
        }
        return intent;
    }

    @Nullable
    public static File createImageFile() {
        return ImageIntent.createImageFile(String.format(IMAGE_FILE_NAME_FORMAT, ImageIntent.createContentFileTimeStamp()));
    }

    @Nullable
    public static File createImageFile(@NonNull String fileName) {
        return ImageIntent.createContentFile(ImageIntent.appendDefaultFileSuffixIfNotPresented(fileName, ".jpg"), Environment.DIRECTORY_PICTURES);
    }

    @Nullable
    static Bitmap processResultIntent(int requestCode, int resultCode, @Nullable Intent data, @NonNull Context context, @Nullable ImageOptions options) {
        if (data == null || resultCode != -1) {
            return null;
        }
        switch (requestCode) {
            case 20481: {
                Uri imageUri = data.getData();
                if (imageUri == null) {
                    return null;
                }
                Bitmap galleryImage = null;
                ContentResolver contentResolver = context.getContentResolver();
                try {
                    if (options == null) {
                        galleryImage = BitmapFactory.decodeStream((InputStream)contentResolver.openInputStream(imageUri));
                    } else {
                        BitmapFactory.Options bmOptions = new BitmapFactory.Options();
                        bmOptions.inJustDecodeBounds = true;
                        BitmapFactory.decodeStream((InputStream)contentResolver.openInputStream(imageUri), null, (BitmapFactory.Options)bmOptions);
                        int bmWidth = bmOptions.outWidth;
                        int bmHeight = bmOptions.outHeight;
                        int scaleFactor = Math.min(bmWidth / options.width, bmHeight / options.height);
                        bmOptions.inJustDecodeBounds = false;
                        bmOptions.inSampleSize = scaleFactor;
                        bmOptions.inPurgeable = true;
                        galleryImage = BitmapFactory.decodeStream((InputStream)contentResolver.openInputStream(imageUri), null, (BitmapFactory.Options)bmOptions);
                    }
                }
                catch (IOException e) {
                    Log.e((String)TAG, (String)("Unable to open stream to image content at uri(" + imageUri + ")."), (Throwable)e);
                }
                return galleryImage;
            }
            case 20482: {
                Bitmap cameraImage;
                Bundle extras = data.getExtras();
                Bitmap bitmap = cameraImage = extras == null ? null : (Bitmap)extras.get("data");
                if (cameraImage != null && options != null) {
                    return Bitmap.createScaledBitmap((Bitmap)cameraImage, (int)options.width, (int)options.height, (boolean)false);
                }
                return cameraImage;
            }
        }
        return null;
    }

    @Override
    public ImageIntent withDefaultHandlers(@NonNull Context context) {
        this.withHandlers(this.onCreateGalleryHandler(context.getResources()), this.cameraHandler = this.onCreateCameraHandler(context.getResources()));
        if (this.uri == null) {
            this.cameraHandler.intent.removeExtra("output");
        } else {
            this.cameraHandler.intent.putExtra("output", (Parcelable)this.uri);
        }
        return this;
    }

    @NonNull
    protected ContentIntent.ContentHandler onCreateGalleryHandler(@NonNull Resources resources) {
        return new ContentIntent.ContentHandler("Gallery", ImageIntent.createGalleryIntent()).requestCode(20481);
    }

    @NonNull
    protected ContentIntent.ContentHandler onCreateCameraHandler(@NonNull Resources resources) {
        return new ContentIntent.ContentHandler("Camera", ImageIntent.createCameraIntent()).requestCode(20482);
    }

    @Override
    public ImageIntent input(@Nullable Uri uri) {
        super.input(uri);
        if (uri != null) {
            this.dataType = "image/*";
        }
        return this;
    }

    @Override
    public ImageIntent output(@Nullable Uri uri) {
        super.output(uri);
        if (this.cameraHandler != null) {
            if (this.uri == null) {
                this.cameraHandler.intent.removeExtra("output");
            } else {
                this.cameraHandler.intent.putExtra("output", (Parcelable)this.uri);
            }
        }
        return this;
    }

    public static class ImageOptions {
        int width;
        int height;

        public ImageOptions inSize(@IntRange(from=0L, to=0x7FFFFFFFL) int width, @IntRange(from=0L, to=0x7FFFFFFFL) int height) {
            this.width = width;
            this.height = height;
            return this;
        }
    }
}

