/*
 * Decompiled with CFR 0.152.
 */
package universum.studios.android.intent;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import android.util.Patterns;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import universum.studios.android.intent.BaseIntent;
import universum.studios.android.intent.IntentStarter;

public class EmailIntent
extends BaseIntent<EmailIntent> {
    private static final String TAG = "EmailIntent";
    public static final String URI_SCHEME = "mailto";
    public static final Matcher EMAIL_MATCHER = Patterns.EMAIL_ADDRESS.matcher("");
    private CharSequence subject;
    private CharSequence message;
    private List<String> addresses;
    private List<String> ccAddresses;
    private List<String> bccAddresses;

    public EmailIntent to(@NonNull String address) {
        if (this.addresses == null) {
            this.addresses = new ArrayList<String>(1);
        }
        EmailIntent.appendEmailAddress(this.addresses, address);
        return this;
    }

    public EmailIntent to(String ... addresses) {
        return this.to(Arrays.asList(addresses));
    }

    public EmailIntent to(@Nullable List<String> addresses) {
        if (addresses == null) {
            this.addresses = null;
        } else {
            if (this.addresses == null) {
                this.addresses = new ArrayList<String>(addresses.size());
            }
            EmailIntent.appendEmailAddresses(this.addresses, addresses);
        }
        return this;
    }

    @NonNull
    public List<String> addresses() {
        return this.addresses == null ? Collections.emptyList() : new ArrayList<String>(this.addresses);
    }

    public EmailIntent cc(@NonNull String address) {
        if (this.ccAddresses == null) {
            this.ccAddresses = new ArrayList<String>(1);
        }
        EmailIntent.appendEmailAddress(this.ccAddresses, address);
        return this;
    }

    public EmailIntent cc(String ... addresses) {
        return this.cc(Arrays.asList(addresses));
    }

    public EmailIntent cc(@Nullable List<String> addresses) {
        if (addresses == null) {
            this.ccAddresses = null;
        } else {
            if (this.ccAddresses == null) {
                this.ccAddresses = new ArrayList<String>(addresses.size());
            }
            EmailIntent.appendEmailAddresses(this.ccAddresses, addresses);
        }
        return this;
    }

    @NonNull
    public List<String> ccAddresses() {
        return this.ccAddresses == null ? Collections.emptyList() : new ArrayList<String>(this.ccAddresses);
    }

    public EmailIntent bcc(@NonNull String address) {
        if (this.bccAddresses == null) {
            this.bccAddresses = new ArrayList<String>(1);
        }
        EmailIntent.appendEmailAddress(this.bccAddresses, address);
        return this;
    }

    public EmailIntent bcc(String ... addresses) {
        return this.bcc(Arrays.asList(addresses));
    }

    public EmailIntent bcc(@Nullable List<String> addresses) {
        if (addresses == null) {
            this.bccAddresses = null;
        } else {
            if (this.bccAddresses == null) {
                this.bccAddresses = new ArrayList<String>(addresses.size());
            }
            EmailIntent.appendEmailAddresses(this.bccAddresses, addresses);
        }
        return this;
    }

    @NonNull
    public List<String> bccAddresses() {
        return this.bccAddresses == null ? Collections.emptyList() : new ArrayList<String>(this.bccAddresses);
    }

    public EmailIntent subject(@NonNull CharSequence subject) {
        this.subject = subject;
        return this;
    }

    @NonNull
    public CharSequence subject() {
        return this.subject == null ? "" : this.subject;
    }

    public EmailIntent message(@NonNull CharSequence message) {
        this.message = message;
        return this;
    }

    @NonNull
    public CharSequence message() {
        return this.message == null ? "" : this.message;
    }

    @Override
    protected void ensureCanBuildOrThrow() {
        super.ensureCanBuildOrThrow();
        if (this.addresses == null) {
            throw this.cannotBuildIntentException("No e-mail address/-es specified.");
        }
    }

    @Override
    @NonNull
    protected Intent onBuild(@NonNull Context context) {
        Intent intent = new Intent("android.intent.action.SENDTO", EmailIntent.createUri(this.addresses));
        intent.putExtra("android.intent.extra.SUBJECT", this.subject);
        intent.putExtra("android.intent.extra.TEXT", this.message);
        if (this.ccAddresses != null) {
            intent.putExtra("android.intent.extra.CC", EmailIntent.addressesToArray(this.ccAddresses));
        }
        if (this.bccAddresses != null) {
            intent.putExtra("android.intent.extra.BCC", EmailIntent.addressesToArray(this.bccAddresses));
        }
        return intent;
    }

    @Nullable
    public static Uri createUri(@NonNull List<String> addresses) {
        int n = addresses.size();
        if (n == 0) {
            return null;
        }
        StringBuilder data = new StringBuilder(n * 15);
        for (int i = 0; i < n; ++i) {
            data.append(addresses.get(i));
            if (i >= n - 1) continue;
            data.append(",");
        }
        return Uri.fromParts((String)URI_SCHEME, (String)data.toString(), null);
    }

    private static String[] addressesToArray(List<String> addresses) {
        String[] addressesArray = new String[addresses.size()];
        addresses.toArray(addressesArray);
        return addressesArray;
    }

    @Override
    protected boolean onStartWith(@NonNull IntentStarter starter, @NonNull Intent intent) {
        return super.onStartWith(starter, Intent.createChooser((Intent)intent, (CharSequence)this.dialogTitle));
    }

    private static void appendEmailAddresses(List<String> list, List<String> addresses) {
        if (!addresses.isEmpty()) {
            for (String address : addresses) {
                EmailIntent.appendEmailAddress(list, address);
            }
        }
    }

    private static void appendEmailAddress(List<String> list, String address) {
        if (EMAIL_MATCHER.reset(address).matches()) {
            list.add(address);
            return;
        }
        Log.e((String)TAG, (String)("Invalid e-mail address('" + address + "') specified."));
    }
}

