/*
 * Decompiled with CFR 0.152.
 */
package universum.studios.android.intent;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.net.Uri;
import android.os.Environment;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import universum.studios.android.intent.BaseIntent;
import universum.studios.android.intent.IntentStarter;

public abstract class ContentIntent<I extends ContentIntent<I>>
extends BaseIntent<I> {
    public static final String CONTENT_FILE_TIME_STAMP_FORMAT = "yyyyMMdd_HHmmss";
    Uri uri;
    String dataType;
    private boolean hasInputUri;
    private List<ContentHandler> handlers;

    @NonNull
    public static String createContentFileTimeStamp() {
        return new SimpleDateFormat(CONTENT_FILE_TIME_STAMP_FORMAT, Locale.getDefault()).format(new Date());
    }

    @Nullable
    public static File createContentFile(@NonNull String fileName, @NonNull String externalDirectoryType) {
        return ContentIntent.createContentFile(fileName, Environment.getExternalStoragePublicDirectory((String)externalDirectoryType));
    }

    @Nullable
    public static File createContentFile(@NonNull String fileName, @NonNull File directory) {
        try {
            File file = new File(directory.getPath() + File.separator + fileName);
            return file.createNewFile() ? file : null;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    static String appendDefaultFileSuffixIfNotPresented(String fileName, String defaultSuffix) {
        return fileName.contains(".") ? fileName : fileName + defaultSuffix;
    }

    public abstract ContentIntent withDefaultHandlers(@NonNull Context var1);

    public I withHandlers(ContentHandler ... handlers) {
        return this.withHandlers(Arrays.asList(handlers));
    }

    public I withHandlers(@Nullable List<ContentHandler> handlers) {
        if (handlers == null) {
            this.handlers = null;
        } else if (!handlers.isEmpty()) {
            if (this.handlers == null) {
                this.handlers = new ArrayList<ContentHandler>(handlers.size());
            }
            this.handlers.addAll(handlers);
        }
        return (I)this;
    }

    public I withHandler(@NonNull ContentHandler handler) {
        if (this.handlers == null) {
            this.handlers = new ArrayList<ContentHandler>(1);
        }
        this.handlers.add(handler);
        return (I)this;
    }

    @NonNull
    public List<ContentHandler> handlers() {
        return this.handlers == null ? Collections.EMPTY_LIST : new ArrayList<ContentHandler>(this.handlers);
    }

    public I input(@Nullable File file) {
        if (file == null) {
            this.input((Uri)null);
        } else {
            this.input(Uri.fromFile((File)file));
        }
        return (I)this;
    }

    public I input(@Nullable Uri uri) {
        this.uri = uri;
        this.dataType = null;
        this.hasInputUri = uri != null;
        return (I)this;
    }

    public I output(@Nullable File file) {
        if (file == null) {
            this.output((Uri)null);
        } else {
            this.output(Uri.fromFile((File)file));
        }
        return (I)this;
    }

    public I output(@Nullable Uri uri) {
        this.uri = uri;
        this.dataType = null;
        this.hasInputUri = false;
        return (I)this;
    }

    @Nullable
    public Uri uri() {
        return this.uri;
    }

    public I dataType(@NonNull String type) {
        this.dataType = type;
        return (I)this;
    }

    @Nullable
    public String dataType() {
        return this.dataType;
    }

    @Override
    public boolean startWith(@NonNull IntentStarter starter) {
        Context context = starter.getContext();
        if (this.handlers == null) {
            Intent intent = this.build(context);
            if (ContentIntent.isActivityForIntentAvailable(context, intent)) {
                return this.onStartWith(starter, intent);
            }
            this.notifyActivityNotFound(context);
            return false;
        }
        this.onShowChooserDialog(starter);
        return true;
    }

    protected void onShowChooserDialog(final @NonNull IntentStarter starter) {
        int n = this.handlers.size();
        CharSequence[] providerNames = new CharSequence[n];
        for (int i = 0; i < n; ++i) {
            providerNames[i] = this.handlers.get((int)i).name;
        }
        AlertDialog.Builder builder = new AlertDialog.Builder(starter.getContext());
        builder.setTitle(this.dialogTitle);
        builder.setItems(providerNames, new DialogInterface.OnClickListener(){

            public void onClick(@NonNull DialogInterface dialog, int which) {
                ContentHandler handler = (ContentHandler)ContentIntent.this.handlers.get(which);
                if (handler.requestCode < 0) {
                    starter.startIntent(handler.intent);
                } else {
                    starter.startIntentForResult(handler.intent, handler.requestCode);
                }
            }
        });
        builder.show();
    }

    @Override
    @NonNull
    public Intent build(@NonNull Context context) {
        if (this.handlers == null) {
            return super.build(context);
        }
        throw new IllegalStateException("Cannot build intent for set of ContentHandlers.");
    }

    @Override
    protected void ensureCanBuildOrThrow() {
        super.ensureCanBuildOrThrow();
        if (this.hasInputUri) {
            if (TextUtils.isEmpty((CharSequence)this.dataType)) {
                throw this.cannotBuildIntentException("No MIME type specified for input Uri.");
            }
        } else {
            throw this.cannotBuildIntentException("No input Uri specified.");
        }
    }

    @Override
    @NonNull
    protected Intent onBuild(@NonNull Context context) {
        return new Intent("android.intent.action.VIEW").setDataAndType(this.uri, this.dataType);
    }

    @Override
    protected boolean onStartWith(@NonNull IntentStarter starter, @NonNull Intent intent) {
        return super.onStartWith(starter, Intent.createChooser((Intent)intent, (CharSequence)this.dialogTitle));
    }

    public static class ContentHandler {
        final CharSequence name;
        final Intent intent;
        int requestCode = -1;

        public ContentHandler(@NonNull CharSequence name, @NonNull Intent intent) {
            this.name = name;
            this.intent = intent;
        }

        @NonNull
        public CharSequence name() {
            return this.name;
        }

        @NonNull
        public Intent intent() {
            return this.intent;
        }

        public ContentHandler requestCode(int code) {
            this.requestCode = code;
            return this;
        }

        public int requestCode() {
            return this.requestCode;
        }
    }
}

