/*
 * Decompiled with CFR 0.152.
 */
package universum.studios.android.intent;

import android.content.Context;
import android.content.Intent;
import android.support.annotation.AnimRes;
import android.support.annotation.CheckResult;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.widget.Toast;
import universum.studios.android.intent.IntentStarter;

public abstract class BaseIntent<I extends BaseIntent> {
    CharSequence dialogTitle = "Choose";
    private CharSequence activityNotFoundMessage = "No application found to handle this action";
    private int enterTransition;
    private int exitTransition;
    private boolean applyTransitions;

    public I dialogTitle(@Nullable CharSequence title) {
        this.dialogTitle = title;
        return (I)this;
    }

    @NonNull
    public CharSequence dialogTitle() {
        return this.dialogTitle == null ? "" : this.dialogTitle;
    }

    public I activityNotFoundMessage(@Nullable CharSequence message) {
        this.activityNotFoundMessage = message;
        return (I)this;
    }

    @NonNull
    public CharSequence activityNotFoundMessage() {
        return this.activityNotFoundMessage == null ? "" : this.activityNotFoundMessage;
    }

    public I enterTransition(@AnimRes int transition) {
        return this.transitions(transition, this.exitTransition);
    }

    @AnimRes
    public int enterTransition() {
        return this.enterTransition;
    }

    public I exitTransition(@AnimRes int transition) {
        return this.transitions(this.enterTransition, transition);
    }

    @AnimRes
    public int exitTransition() {
        return this.exitTransition;
    }

    public I transitions(@AnimRes int enterTransition, @AnimRes int exitTransition) {
        this.enterTransition = enterTransition;
        this.exitTransition = exitTransition;
        this.applyTransitions = enterTransition != 0 || exitTransition != 0;
        return (I)this;
    }

    public boolean startWith(@NonNull IntentStarter starter) {
        Intent intent;
        Context context = starter.getContext();
        if (BaseIntent.isActivityForIntentAvailable(context, intent = this.build(context))) {
            return this.onStartWith(starter, intent);
        }
        this.notifyActivityNotFound(context);
        return false;
    }

    @NonNull
    public Intent build(@NonNull Context context) {
        this.ensureCanBuildOrThrow();
        return this.onBuild(context);
    }

    protected void ensureCanBuildOrThrow() {
    }

    @NonNull
    protected abstract Intent onBuild(@NonNull Context var1);

    @CheckResult
    public static boolean isActivityForIntentAvailable(@NonNull Context context, @NonNull Intent intent) {
        return intent.resolveActivity(context.getPackageManager()) != null;
    }

    protected final IllegalArgumentException cannotBuildIntentException(@NonNull String message) {
        return new IllegalArgumentException("Cannot build " + this.getClass().getSimpleName() + ". " + message);
    }

    protected boolean onStartWith(@NonNull IntentStarter starter, @NonNull Intent intent) {
        starter.startIntent(intent);
        if (this.applyTransitions) {
            starter.overridePendingTransition(this.enterTransition, this.exitTransition);
        }
        return true;
    }

    protected void notifyActivityNotFound(@NonNull Context context) {
        Toast.makeText((Context)context, (CharSequence)this.activityNotFoundMessage, (int)1).show();
    }
}

