/*
 * Decompiled with CFR 0.152.
 */
package universum.studios.android.intent;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import universum.studios.android.intent.BaseIntent;
import universum.studios.android.intent.IntentStarter;

public class ShareIntent
extends BaseIntent<ShareIntent> {
    private String mDataType = "text/*";
    private CharSequence mTitle;
    private CharSequence mContent;
    private Uri mUri;
    private List<Uri> mUris;

    public ShareIntent content(@Nullable CharSequence text) {
        this.mContent = text;
        return this;
    }

    @NonNull
    public CharSequence content() {
        return this.mContent == null ? "" : this.mContent;
    }

    public ShareIntent uri(@Nullable Uri uri) {
        this.mUri = uri;
        return this;
    }

    @Nullable
    public Uri uri() {
        return this.mUri;
    }

    public ShareIntent uris(Uri ... uris) {
        return this.uris(Arrays.asList(uris));
    }

    public ShareIntent uris(@Nullable List<Uri> uris) {
        this.mUris = uris;
        return this;
    }

    @NonNull
    public List<Uri> uris() {
        return this.mUris == null ? Collections.EMPTY_LIST : new ArrayList<Uri>(this.mUris);
    }

    public ShareIntent mimeType(@NonNull String type) {
        this.mDataType = type;
        return this;
    }

    @NonNull
    public String mimeType() {
        return this.mDataType;
    }

    public ShareIntent title(@Nullable CharSequence title) {
        this.mTitle = title;
        return this;
    }

    @NonNull
    public CharSequence title() {
        return this.mTitle == null ? "" : this.mTitle;
    }

    @Override
    protected void ensureCanBuildOrThrow() {
        super.ensureCanBuildOrThrow();
        if (TextUtils.isEmpty((CharSequence)this.mContent) && this.mUri == null && this.mUris == null) {
            throw this.cannotBuildIntentException("No content to share specified.");
        }
        if (TextUtils.isEmpty((CharSequence)this.mDataType)) {
            throw this.cannotBuildIntentException("No content's MIME type specified.");
        }
    }

    @Override
    @NonNull
    protected Intent onBuild(@NonNull Context context) {
        Intent intent = new Intent("android.intent.action.SEND");
        intent.setType(this.mDataType);
        if (!TextUtils.isEmpty((CharSequence)this.mTitle)) {
            intent.putExtra("android.intent.extra.TITLE", this.mTitle);
        }
        if (!TextUtils.isEmpty((CharSequence)this.mContent)) {
            intent.putExtra("android.intent.extra.TEXT", this.mContent);
        }
        if (this.mUri != null) {
            intent.putExtra("android.intent.extra.STREAM", (Parcelable)this.mUri);
        } else if (this.mUris != null) {
            intent.setAction("android.intent.action.SEND_MULTIPLE");
            intent.putParcelableArrayListExtra("android.intent.extra.STREAM", new ArrayList<Uri>(this.mUris));
        }
        return intent;
    }

    @Override
    protected boolean onStartWith(@NonNull IntentStarter starter, @NonNull Intent intent) {
        return super.onStartWith(starter, Intent.createChooser((Intent)intent, (CharSequence)this.mDialogTitle));
    }
}

