/*
 * Decompiled with CFR 0.152.
 */
package universum.studios.android.intent;

import android.content.ContentUris;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.provider.CalendarContract;
import android.support.annotation.IntRange;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import universum.studios.android.intent.BaseIntent;

public class CalendarIntent
extends BaseIntent<CalendarIntent> {
    public static final int TYPE_VIEW = 1;
    public static final int TYPE_INSERT_EVENT = 2;
    public static final int TYPE_EDIT_EVENT = 3;
    public static final int TYPE_VIEW_EVENT = 4;
    public static final int AVAILABILITY_BUSY = 0;
    public static final int AVAILABILITY_FREE = 1;
    public static final int AVAILABILITY_TENTATIVE = 2;
    private int mType = 1;
    private long mEventId = -1L;
    private long mBeginTime = System.currentTimeMillis();
    private long mEndTime = this.mBeginTime + 1L;
    private CharSequence mTitle;
    private CharSequence mDescription;
    private CharSequence mLocation;
    private int mAvailability = 0;

    public CalendarIntent type(int type) {
        this.mType = type;
        return this;
    }

    public int type() {
        return this.mType;
    }

    public CalendarIntent eventId(@IntRange(from=1L, to=0x7FFFFFFFFFFFFFFFL) long eventId) {
        this.mEventId = eventId;
        return this;
    }

    public long eventId() {
        return this.mEventId;
    }

    public CalendarIntent time(@IntRange(from=0L, to=0x7FFFFFFFFFFFFFFFL) long time) {
        this.mBeginTime = time;
        return this;
    }

    public long time() {
        return this.mBeginTime;
    }

    public CalendarIntent beginTime(@IntRange(from=0L, to=0x7FFFFFFFFFFFFFFFL) long beginTime) {
        this.mBeginTime = beginTime;
        return this;
    }

    public long beginTime() {
        return this.mBeginTime;
    }

    public CalendarIntent endTime(@IntRange(from=0L, to=0x7FFFFFFFFFFFFFFFL) long endTime) {
        this.mEndTime = endTime;
        return this;
    }

    public long endTime() {
        return this.mEndTime;
    }

    public CalendarIntent title(@Nullable CharSequence title) {
        this.mTitle = title;
        return this;
    }

    @NonNull
    public CharSequence title() {
        return this.mTitle == null ? "" : this.mTitle;
    }

    public CalendarIntent description(@Nullable CharSequence description) {
        this.mDescription = description;
        return this;
    }

    @NonNull
    public CharSequence description() {
        return this.mDescription == null ? "" : this.mDescription;
    }

    public CalendarIntent location(@Nullable CharSequence location) {
        this.mLocation = location;
        return this;
    }

    @NonNull
    public CharSequence location() {
        return this.mLocation == null ? "" : this.mLocation;
    }

    public CalendarIntent availability(int availability) {
        this.mAvailability = availability;
        return this;
    }

    public int availability() {
        return this.mAvailability;
    }

    @Override
    protected void ensureCanBuildOrThrow() {
        super.ensureCanBuildOrThrow();
        switch (this.mType) {
            case 1: {
                if (this.mBeginTime >= 0L) break;
                throw this.cannotBuildIntentException("Specified invalid time(" + this.mBeginTime + ") where to open calendar for view. Must be none-negative time value.");
            }
            case 2: {
                if (this.mBeginTime < 0L) {
                    throw this.cannotBuildIntentException("Specified invalid begin time(" + this.mBeginTime + "). Must be none-negative time value.");
                }
                if (this.mEndTime < 0L) {
                    throw this.cannotBuildIntentException("Specified invalid end time(" + this.mEndTime + "). Must be none-negative time value.");
                }
                if (this.mEndTime > this.mBeginTime) break;
                throw this.cannotBuildIntentException("Specified end time(" + this.mEndTime + ") is before/at begin time(" + this.mBeginTime + "). Must be greater than the begin time.");
            }
            default: {
                if (this.mEventId > 0L) break;
                throw this.cannotBuildIntentException("Specified invalid event id(" + this.mEventId + ").");
            }
        }
    }

    @Override
    @NonNull
    protected Intent onBuild(@NonNull Context context) {
        switch (this.mType) {
            case 1: {
                Uri.Builder builder = CalendarContract.CONTENT_URI.buildUpon();
                builder.appendPath("time");
                ContentUris.appendId((Uri.Builder)builder, (long)this.mBeginTime);
                return new Intent("android.intent.action.VIEW").setData(builder.build());
            }
            case 2: {
                return new Intent("android.intent.action.INSERT").setData(CalendarContract.Events.CONTENT_URI).putExtra("beginTime", this.mBeginTime).putExtra("endTime", this.mEndTime).putExtra("title", this.mTitle).putExtra("description", this.mDescription).putExtra("eventLocation", this.mLocation).putExtra("availability", this.mAvailability);
            }
            case 3: {
                Intent intent = new Intent("android.intent.action.EDIT");
                intent.setData(ContentUris.withAppendedId((Uri)CalendarContract.Events.CONTENT_URI, (long)this.mEventId));
                if (!TextUtils.isEmpty((CharSequence)this.mTitle)) {
                    intent.putExtra("title", this.mTitle);
                }
                return intent;
            }
        }
        return new Intent("android.intent.action.VIEW").setData(ContentUris.withAppendedId((Uri)CalendarContract.Events.CONTENT_URI, (long)this.mEventId));
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Availability {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Type {
    }
}

