/*
 * Decompiled with CFR 0.152.
 */
package universum.studios.android.intent;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.support.annotation.FloatRange;
import android.support.annotation.IntRange;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import universum.studios.android.intent.BaseIntent;

public class MapIntent
extends BaseIntent<MapIntent> {
    private static final String TAG = "MapIntent";
    public static final String URI_SCHEME = "geo";
    public static final double LAT_MIN = -90.0;
    public static final double LAT_MAX = 90.0;
    public static final double LNG_MIN = -180.0;
    public static final double LNG_MAX = 180.0;
    public static final int ZOOM_LEVEL_MIN = 1;
    public static final int ZOOM_LEVEL_MAX = 23;
    private double mLng;
    private double mLat;
    private int mZoomLevel;
    private String mLabel;
    private String mLocationQuery;
    private boolean mLatLngSet;

    public MapIntent location(@FloatRange(from=-90.0, to=90.0) double lat, @FloatRange(from=-180.0, to=180.0) double lng) {
        this.mLat = Math.max(-90.0, Math.min(90.0, lat));
        this.mLng = Math.max(-180.0, Math.min(180.0, lng));
        this.mLatLngSet = true;
        return this;
    }

    @FloatRange(from=-90.0, to=90.0)
    public double lat() {
        return this.mLat;
    }

    @FloatRange(from=-180.0, to=180.0)
    public double lng() {
        return this.mLng;
    }

    public MapIntent locationQuery(@Nullable String query) {
        this.mLocationQuery = query;
        return this;
    }

    @NonNull
    public String locationQuery() {
        return this.mLocationQuery == null ? "" : this.mLocationQuery;
    }

    public MapIntent zoomLevel(@IntRange(from=1L, to=23L) int level) {
        this.mZoomLevel = Math.max(1, Math.min(23, level));
        return this;
    }

    @IntRange(from=0L, to=23L)
    public int zoomLevel() {
        return this.mZoomLevel;
    }

    public MapIntent label(@Nullable String label) {
        this.mLabel = label;
        return this;
    }

    @NonNull
    public String label() {
        return this.mLabel == null ? "" : this.mLabel;
    }

    @Override
    protected void ensureCanBuildOrThrow() {
        super.ensureCanBuildOrThrow();
        if (!this.mLatLngSet && TextUtils.isEmpty((CharSequence)this.mLocationQuery)) {
            throw this.cannotBuildIntentException("No latitude and longitude nor location query specified.");
        }
    }

    @Override
    @NonNull
    protected Intent onBuild(@NonNull Context context) {
        StringBuilder uriBuilder = new StringBuilder(64);
        if (this.mLatLngSet) {
            if (TextUtils.isEmpty((CharSequence)this.mLabel)) {
                uriBuilder.append(this.mLat);
                uriBuilder.append(",");
                uriBuilder.append(this.mLng);
                if (this.mZoomLevel != 0) {
                    uriBuilder.append("?z=");
                    uriBuilder.append(this.mZoomLevel);
                }
                if (!TextUtils.isEmpty((CharSequence)this.mLocationQuery)) {
                    uriBuilder.append(this.mZoomLevel == 0 ? "?" : "&");
                    this.appendLocationQuery(uriBuilder);
                }
            } else {
                uriBuilder.append("0,0?q=");
                uriBuilder.append(this.mLat);
                uriBuilder.append(",");
                uriBuilder.append(this.mLng);
                this.appendLabel(uriBuilder);
            }
        } else {
            uriBuilder.append("0,0?");
            this.appendLocationQuery(uriBuilder);
            if (!TextUtils.isEmpty((CharSequence)this.mLabel)) {
                this.appendLabel(uriBuilder);
            }
        }
        return new Intent("android.intent.action.VIEW", Uri.parse((String)("geo:" + uriBuilder.toString())));
    }

    private void appendLocationQuery(StringBuilder uriBuilder) {
        uriBuilder.append("q=").append(Uri.encode((String)this.mLocationQuery));
    }

    private void appendLabel(StringBuilder uriBuilder) {
        uriBuilder.append("(").append(Uri.encode((String)this.mLabel)).append(")");
    }
}

