/*
 * Decompiled with CFR 0.152.
 */
package universum.studios.android.intent;

import android.content.Context;
import android.content.Intent;
import android.content.res.Resources;
import android.net.Uri;
import android.os.Environment;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import java.io.File;
import universum.studios.android.intent.ContentIntent;

public class VideoIntent
extends ContentIntent<VideoIntent> {
    public static final int REQUEST_CODE_GALLERY = 20497;
    public static final int REQUEST_CODE_CAMERA = 20498;
    public static final String VIDEO_FILE_NAME_FORMAT = "VIDEO_%s";
    private ContentIntent.ContentHandler mCameraHandler;

    @NonNull
    public static Intent createGalleryIntent() {
        return new Intent("android.intent.action.GET_CONTENT").setType("video/*");
    }

    @NonNull
    public static Intent createCameraIntent() {
        return VideoIntent.createCameraIntent((Uri)null);
    }

    @NonNull
    public static Intent createCameraIntent(@Nullable File outputFile) {
        return VideoIntent.createCameraIntent(outputFile != null ? Uri.fromFile((File)outputFile) : null);
    }

    @NonNull
    public static Intent createCameraIntent(@Nullable Uri outputUri) {
        Intent intent = new Intent("android.media.action.VIDEO_CAPTURE");
        if (outputUri != null) {
            intent.putExtra("output", (Parcelable)outputUri);
        }
        return intent;
    }

    @Nullable
    public static File createVideoFile() {
        return VideoIntent.createVideoFile(String.format(VIDEO_FILE_NAME_FORMAT, VideoIntent.createContentFileTimeStamp()));
    }

    @Nullable
    public static File createVideoFile(@NonNull String fileName) {
        return VideoIntent.createContentFile(VideoIntent.appendDefaultFileSuffixIfNotPresented(fileName, ".mp4"), Environment.DIRECTORY_MOVIES);
    }

    @Override
    public VideoIntent withDefaultHandlers(@NonNull Context context) {
        this.withHandlers(this.onCreateGalleryHandler(context.getResources()), this.mCameraHandler = this.onCreateCameraHandler(context.getResources()));
        if (this.mUri != null) {
            this.mCameraHandler.intent.putExtra("output", (Parcelable)this.mUri);
        } else {
            this.mCameraHandler.intent.removeExtra("output");
        }
        return this;
    }

    @NonNull
    protected ContentIntent.ContentHandler onCreateGalleryHandler(@NonNull Resources resources) {
        return new ContentIntent.ContentHandler("Gallery", VideoIntent.createGalleryIntent()).requestCode(20497);
    }

    @NonNull
    protected ContentIntent.ContentHandler onCreateCameraHandler(@NonNull Resources resources) {
        return new ContentIntent.ContentHandler("Camera", VideoIntent.createCameraIntent()).requestCode(20498);
    }

    @Override
    public VideoIntent input(@Nullable Uri uri) {
        super.input(uri);
        if (uri != null) {
            this.mDataType = "video/*";
        }
        return this;
    }

    @Override
    public VideoIntent output(@Nullable Uri uri) {
        super.output(uri);
        if (this.mCameraHandler != null) {
            if (this.mUri != null) {
                this.mCameraHandler.intent.putExtra("output", (Parcelable)this.mUri);
            } else {
                this.mCameraHandler.intent.removeExtra("output");
            }
        }
        return this;
    }
}

