/*
 * Decompiled with CFR 0.152.
 */
package universum.studios.android.intent;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import universum.studios.android.intent.BaseIntent;

public final class SmsIntent
extends BaseIntent {
    public static final String URI_SCHEME = "sms";
    private String mPhoneNumber;
    private CharSequence mBody;

    public SmsIntent phoneNumber(@Nullable String number) {
        this.mPhoneNumber = number;
        return this;
    }

    @NonNull
    public String phoneNumber() {
        return this.mPhoneNumber != null ? this.mPhoneNumber : "";
    }

    public SmsIntent body(@NonNull CharSequence body) {
        this.mBody = body;
        return this;
    }

    @NonNull
    public CharSequence body() {
        return this.mBody != null ? this.mBody : "";
    }

    @Override
    protected void ensureCanBuildOrThrow() {
        super.ensureCanBuildOrThrow();
        if (TextUtils.isEmpty((CharSequence)this.mPhoneNumber)) {
            throw this.cannotBuildIntentException("No phone number specified.");
        }
    }

    @Override
    @NonNull
    protected Intent onBuild(@NonNull Context context) {
        Intent intent = new Intent("android.intent.action.VIEW", Uri.fromParts((String)URI_SCHEME, (String)this.mPhoneNumber, null));
        if (!TextUtils.isEmpty((CharSequence)this.mBody)) {
            intent.putExtra("sms_body", this.mBody);
        }
        return intent;
    }
}

