/*
 * Decompiled with CFR 0.152.
 */
package universum.studios.android.intent;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.support.annotation.IntRange;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import universum.studios.android.intent.BaseIntent;
import universum.studios.android.intent.IntentStarter;

public class SimpleIntent
extends BaseIntent<SimpleIntent> {
    private static final int TYPE_ACTIVITY = 1;
    private static final int TYPE_ACTION = 2;
    private int mType = 0;
    private String mAction = null;
    private Class<? extends Activity> mActivityClass = null;
    private int mFlags;
    private int mRequestCode = -1;
    private boolean mForResult = false;

    public SimpleIntent activityClass(@NonNull Class<? extends Activity> activityClass) {
        this.mActivityClass = activityClass;
        this.mType = 1;
        return this;
    }

    @Nullable
    public Class<? extends Activity> activityClass() {
        return this.mActivityClass;
    }

    public SimpleIntent action(@NonNull String action) {
        this.mAction = action;
        this.mType = 2;
        return this;
    }

    @NonNull
    public String action() {
        return this.mAction != null ? this.mAction : "";
    }

    public SimpleIntent flags(@IntRange(from=0L, to=0x7FFFFFFFL) int flags) {
        this.mFlags = flags;
        return this;
    }

    public SimpleIntent flag(@IntRange(from=1L, to=0x7FFFFFFFL) int flag) {
        this.mFlags |= flag;
        return this;
    }

    @IntRange(from=0L, to=0x7FFFFFFFL)
    public int flags() {
        return this.mFlags;
    }

    public SimpleIntent requestCode(int requestCode) {
        this.mRequestCode = requestCode;
        this.mForResult = this.mRequestCode >= 0;
        return this;
    }

    public int requestCode() {
        return this.mRequestCode;
    }

    @Override
    protected void ensureCanBuildOrThrow() {
        super.ensureCanBuildOrThrow();
        switch (this.mType) {
            case 1: {
                if (this.mActivityClass == null) {
                    throw this.cannotBuildIntentException("No activity class specified.");
                }
                return;
            }
            case 2: {
                if (this.mAction == null) {
                    throw this.cannotBuildIntentException("No action specified.");
                }
                return;
            }
        }
        throw this.cannotBuildIntentException("No activity class or action specified.");
    }

    @Override
    @NonNull
    protected Intent onBuild(@NonNull Context context) {
        switch (this.mType) {
            case 2: {
                return new Intent(this.mAction).setFlags(this.mFlags);
            }
        }
        return new Intent(context, this.mActivityClass).setFlags(this.mFlags);
    }

    @Override
    protected boolean onStartWith(@NonNull IntentStarter starter, @NonNull Intent intent) {
        if (this.mForResult) {
            starter.startIntentForResult(intent, this.mRequestCode);
        } else {
            starter.startIntent(intent);
        }
        return true;
    }
}

