/*
 * Decompiled with CFR 0.152.
 */
package universum.studios.android.intent;

import android.content.Context;
import android.content.Intent;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.os.Environment;
import android.os.Parcelable;
import android.support.annotation.IntRange;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import universum.studios.android.intent.ContentIntent;

public class ImageIntent
extends ContentIntent<ImageIntent> {
    private static final String TAG = "ImageIntent";
    public static final int REQUEST_CODE_GALLERY = 20481;
    public static final int REQUEST_CODE_CAMERA = 20482;
    public static final String IMAGE_FILE_NAME_FORMAT = "IMAGE_%s";
    private ContentIntent.ContentHandler mCameraHandler;

    @NonNull
    public static Intent createGalleryIntent() {
        return new Intent("android.intent.action.GET_CONTENT").setType("image/*");
    }

    @NonNull
    public static Intent createCameraIntent() {
        return ImageIntent.createCameraIntent((Uri)null);
    }

    @NonNull
    public static Intent createCameraIntent(@Nullable File outputFile) {
        return ImageIntent.createCameraIntent(outputFile != null ? Uri.fromFile((File)outputFile) : null);
    }

    @NonNull
    public static Intent createCameraIntent(@Nullable Uri outputUri) {
        Intent intent = new Intent("android.media.action.IMAGE_CAPTURE");
        if (outputUri != null) {
            intent.putExtra("output", (Parcelable)outputUri);
        }
        return intent;
    }

    @Nullable
    public static File createImageFile() {
        return ImageIntent.createImageFile(String.format(IMAGE_FILE_NAME_FORMAT, ImageIntent.createContentFileTimeStamp()));
    }

    @Nullable
    public static File createImageFile(@NonNull String fileName) {
        return ImageIntent.createContentFile(ImageIntent.appendDefaultFileSuffixIfNotPresented(fileName, ".jpg"), Environment.DIRECTORY_PICTURES);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Nullable
    static Bitmap processResultIntent(int requestCode, int resultCode, @Nullable Intent data, @NonNull Context context, @Nullable ImageOptions options) {
        if (data == null || resultCode != -1) {
            return null;
        }
        switch (requestCode) {
            case 20481: {
                imageUri = data.getData();
                galleryImage = null;
                if (imageUri == null) ** GOTO lbl82
                stream = null;
                stream = context.getContentResolver().openInputStream(imageUri);
                if (stream == null) ** GOTO lbl82
                if (options == null) ** GOTO lbl25
                bmOptions = new BitmapFactory.Options();
                bmOptions.inJustDecodeBounds = true;
                BitmapFactory.decodeStream((InputStream)stream, null, (BitmapFactory.Options)bmOptions);
                bmWidth = bmOptions.outWidth;
                bmHeight = bmOptions.outHeight;
                scaleFactor = Math.min(bmWidth / options.width, bmHeight / options.height);
                bmOptions.inJustDecodeBounds = false;
                bmOptions.inSampleSize = scaleFactor;
                bmOptions.inPurgeable = true;
                galleryImage = BitmapFactory.decodeStream((InputStream)stream, null, (BitmapFactory.Options)bmOptions);
                ** GOTO lbl26
lbl25:
                // 1 sources

                galleryImage = BitmapFactory.decodeStream((InputStream)stream);
lbl26:
                // 2 sources

                try {
                    stream.close();
                }
                catch (IOException e) {
                    Log.e((String)"ImageIntent", (String)("Unable to close image content at uri(" + imageUri + ")."), (Throwable)e);
                }
                ** GOTO lbl82
                catch (Exception e) {
                    try {
                        Log.e((String)"ImageIntent", (String)("Unable to open image content at uri(" + imageUri + ")."), (Throwable)e);
                        if (stream == null) ** GOTO lbl82
                        if (options == null) ** GOTO lbl74
                    }
                    catch (Throwable var12_22) {
                        if (stream != null) {
                            if (options != null) {
                                bmOptions = new BitmapFactory.Options();
                                bmOptions.inJustDecodeBounds = true;
                                BitmapFactory.decodeStream((InputStream)stream, null, (BitmapFactory.Options)bmOptions);
                                bmWidth = bmOptions.outWidth;
                                bmHeight = bmOptions.outHeight;
                                scaleFactor = Math.min(bmWidth / options.width, bmHeight / options.height);
                                bmOptions.inJustDecodeBounds = false;
                                bmOptions.inSampleSize = scaleFactor;
                                bmOptions.inPurgeable = true;
                                galleryImage = BitmapFactory.decodeStream((InputStream)stream, null, (BitmapFactory.Options)bmOptions);
                            } else {
                                galleryImage = BitmapFactory.decodeStream((InputStream)stream);
                            }
                            try {
                                stream.close();
                            }
                            catch (IOException e) {
                                Log.e((String)"ImageIntent", (String)("Unable to close image content at uri(" + imageUri + ")."), (Throwable)e);
                            }
                        }
                        throw var12_22;
                    }
                    bmOptions = new BitmapFactory.Options();
                    bmOptions.inJustDecodeBounds = true;
                    BitmapFactory.decodeStream((InputStream)stream, null, (BitmapFactory.Options)bmOptions);
                    bmWidth = bmOptions.outWidth;
                    bmHeight = bmOptions.outHeight;
                    scaleFactor = Math.min(bmWidth / options.width, bmHeight / options.height);
                    bmOptions.inJustDecodeBounds = false;
                    bmOptions.inSampleSize = scaleFactor;
                    bmOptions.inPurgeable = true;
                    galleryImage = BitmapFactory.decodeStream((InputStream)stream, null, (BitmapFactory.Options)bmOptions);
                    ** GOTO lbl75
lbl74:
                    // 1 sources

                    galleryImage = BitmapFactory.decodeStream((InputStream)stream);
lbl75:
                    // 2 sources

                    try {
                        stream.close();
                    }
                    catch (IOException e) {
                        Log.e((String)"ImageIntent", (String)("Unable to close image content at uri(" + imageUri + ")."), (Throwable)e);
                    }
                }
lbl82:
                // 7 sources

                return galleryImage;
            }
            case 20482: {
                extras = data.getExtras();
                try {
                    v0 = cameraImage = extras != null ? (Bitmap)extras.get("data") : null;
                    if (cameraImage != null && options != null) {
                        return Bitmap.createScaledBitmap((Bitmap)cameraImage, (int)options.width, (int)options.height, (boolean)false);
                    }
                    return cameraImage;
                }
                catch (Exception e) {
                    Log.e((String)"ImageIntent", (String)"Failed to retrieve captured image.", (Throwable)e);
                }
            }
        }
        return null;
    }

    @Override
    public ImageIntent withDefaultHandlers(@NonNull Context context) {
        this.withHandlers(this.onCreateGalleryHandler(context.getResources()), this.mCameraHandler = this.onCreateCameraHandler(context.getResources()));
        if (this.mUri != null) {
            this.mCameraHandler.intent.putExtra("output", (Parcelable)this.mUri);
        } else {
            this.mCameraHandler.intent.removeExtra("output");
        }
        return this;
    }

    @NonNull
    protected ContentIntent.ContentHandler onCreateGalleryHandler(@NonNull Resources resources) {
        return new ContentIntent.ContentHandler("Gallery", ImageIntent.createGalleryIntent()).requestCode(20481);
    }

    @NonNull
    protected ContentIntent.ContentHandler onCreateCameraHandler(@NonNull Resources resources) {
        return new ContentIntent.ContentHandler("Camera", ImageIntent.createCameraIntent()).requestCode(20482);
    }

    @Override
    public ImageIntent input(@Nullable Uri uri) {
        super.input(uri);
        if (uri != null) {
            this.mDataType = "image/*";
        }
        return this;
    }

    @Override
    public ImageIntent output(@Nullable Uri uri) {
        super.output(uri);
        if (this.mCameraHandler != null) {
            if (this.mUri != null) {
                this.mCameraHandler.intent.putExtra("output", (Parcelable)this.mUri);
            } else {
                this.mCameraHandler.intent.removeExtra("output");
            }
        }
        return this;
    }

    public static class ImageOptions {
        int width;
        int height;

        public ImageOptions inSize(@IntRange(from=0L, to=0x7FFFFFFFL) int width, @IntRange(from=0L, to=0x7FFFFFFFL) int height) {
            this.width = width;
            this.height = height;
            return this;
        }
    }
}

