/*
 * Decompiled with CFR 0.152.
 */
package universum.studios.android.intent;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import android.util.Patterns;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import universum.studios.android.intent.BaseIntent;
import universum.studios.android.intent.IntentStarter;

public class EmailIntent
extends BaseIntent<EmailIntent> {
    private static final String TAG = "EmailIntent";
    public static final String URI_SCHEME = "mailto";
    public static final Matcher EMAIL_MATCHER = Patterns.EMAIL_ADDRESS.matcher("");
    private CharSequence mSubject;
    private CharSequence mMessage;
    private List<String> mAddresses;
    private List<String> mCcAddresses;
    private List<String> mBccAddresses;

    public EmailIntent to(@NonNull String address) {
        if (this.mAddresses == null) {
            this.mAddresses = new ArrayList<String>(1);
        }
        EmailIntent.appendEmailAddress(this.mAddresses, address);
        return this;
    }

    public EmailIntent to(String ... addresses) {
        return this.to(Arrays.asList(addresses));
    }

    public EmailIntent to(@Nullable List<String> addresses) {
        if (addresses != null) {
            if (this.mAddresses == null) {
                this.mAddresses = new ArrayList<String>(addresses.size());
            }
            EmailIntent.appendEmailAddresses(this.mAddresses, addresses);
        } else {
            this.mAddresses = null;
        }
        return this;
    }

    @NonNull
    public List<String> addresses() {
        return this.mAddresses != null ? new ArrayList<String>(this.mAddresses) : Collections.EMPTY_LIST;
    }

    public EmailIntent cc(@NonNull String address) {
        if (this.mCcAddresses == null) {
            this.mCcAddresses = new ArrayList<String>(1);
        }
        EmailIntent.appendEmailAddress(this.mCcAddresses, address);
        return this;
    }

    public EmailIntent cc(String ... addresses) {
        return this.cc(Arrays.asList(addresses));
    }

    public EmailIntent cc(@Nullable List<String> addresses) {
        if (addresses != null) {
            if (this.mCcAddresses == null) {
                this.mCcAddresses = new ArrayList<String>(addresses.size());
            }
            EmailIntent.appendEmailAddresses(this.mCcAddresses, addresses);
        } else {
            this.mCcAddresses = null;
        }
        return this;
    }

    @NonNull
    public List<String> ccAddresses() {
        return this.mCcAddresses != null ? new ArrayList<String>(this.mCcAddresses) : Collections.EMPTY_LIST;
    }

    public EmailIntent bcc(@NonNull String address) {
        if (this.mBccAddresses == null) {
            this.mBccAddresses = new ArrayList<String>(1);
        }
        EmailIntent.appendEmailAddress(this.mBccAddresses, address);
        return this;
    }

    public EmailIntent bcc(String ... addresses) {
        return this.bcc(Arrays.asList(addresses));
    }

    public EmailIntent bcc(@Nullable List<String> addresses) {
        if (addresses != null) {
            if (this.mBccAddresses == null) {
                this.mBccAddresses = new ArrayList<String>(addresses.size());
            }
            EmailIntent.appendEmailAddresses(this.mBccAddresses, addresses);
        } else {
            this.mBccAddresses = null;
        }
        return this;
    }

    @NonNull
    public List<String> bccAddresses() {
        return this.mBccAddresses != null ? new ArrayList<String>(this.mBccAddresses) : Collections.EMPTY_LIST;
    }

    public EmailIntent subject(@NonNull CharSequence subject) {
        this.mSubject = subject;
        return this;
    }

    @NonNull
    public CharSequence subject() {
        return this.mSubject != null ? this.mSubject : "";
    }

    public EmailIntent message(@NonNull CharSequence message) {
        this.mMessage = message;
        return this;
    }

    @NonNull
    public CharSequence message() {
        return this.mMessage != null ? this.mMessage : "";
    }

    @Override
    protected void ensureCanBuildOrThrow() {
        super.ensureCanBuildOrThrow();
        if (this.mAddresses == null) {
            throw this.cannotBuildIntentException("No e-mail address/-es specified.");
        }
    }

    @Override
    @NonNull
    protected Intent onBuild(@NonNull Context context) {
        Intent intent = new Intent("android.intent.action.SENDTO", EmailIntent.createUri(this.mAddresses));
        intent.putExtra("android.intent.extra.SUBJECT", this.mSubject);
        intent.putExtra("android.intent.extra.TEXT", this.mMessage);
        if (this.mCcAddresses != null) {
            intent.putExtra("android.intent.extra.CC", EmailIntent.addressesToArray(this.mCcAddresses));
        }
        if (this.mBccAddresses != null) {
            intent.putExtra("android.intent.extra.BCC", EmailIntent.addressesToArray(this.mBccAddresses));
        }
        return intent;
    }

    @Nullable
    public static Uri createUri(@NonNull List<String> addresses) {
        int n = addresses.size();
        if (n == 0) {
            return null;
        }
        StringBuilder data = new StringBuilder(n * 15);
        for (int i = 0; i < n; ++i) {
            data.append(addresses.get(i));
            if (i >= n - 1) continue;
            data.append(",");
        }
        return Uri.fromParts((String)URI_SCHEME, (String)data.toString(), null);
    }

    private static String[] addressesToArray(List<String> addresses) {
        String[] addressesArray = new String[addresses.size()];
        addresses.toArray(addressesArray);
        return addressesArray;
    }

    @Override
    protected boolean onStartWith(@NonNull IntentStarter starter, @NonNull Intent intent) {
        return super.onStartWith(starter, Intent.createChooser((Intent)intent, (CharSequence)this.mDialogTitle));
    }

    private static void appendEmailAddresses(List<String> list, List<String> addresses) {
        if (addresses.size() > 0) {
            for (String address : addresses) {
                EmailIntent.appendEmailAddress(list, address);
            }
        }
    }

    private static void appendEmailAddress(List<String> list, String address) {
        if (!EMAIL_MATCHER.reset(address).matches()) {
            Log.e((String)TAG, (String)("Invalid e-mail address('" + address + "') specified."));
            return;
        }
        list.add(address);
    }
}

