/*
 * Decompiled with CFR 0.152.
 */
package universum.studios.android.intent;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.net.Uri;
import android.os.Environment;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import universum.studios.android.intent.BaseIntent;
import universum.studios.android.intent.IntentStarter;

public abstract class ContentIntent<I extends ContentIntent<I>>
extends BaseIntent<I> {
    public static final String CONTENT_FILE_TIME_STAMP_FORMAT = "yyyyMMdd_HHmmss";
    Uri mUri;
    String mDataType;
    private boolean mHasInputUri;
    private List<ContentHandler> mHandlers;

    @NonNull
    public static String createContentFileTimeStamp() {
        return new SimpleDateFormat(CONTENT_FILE_TIME_STAMP_FORMAT, Locale.getDefault()).format(new Date());
    }

    @Nullable
    public static File createContentFile(@NonNull String fileName, @NonNull String externalDirectoryType) {
        return ContentIntent.createContentFile(fileName, Environment.getExternalStoragePublicDirectory((String)externalDirectoryType));
    }

    @Nullable
    public static File createContentFile(@NonNull String fileName, @NonNull File directory) {
        try {
            File file = new File(directory.getPath() + File.separator + fileName);
            return file.createNewFile() ? file : null;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    static String appendDefaultFileSuffixIfNotPresented(String fileName, String defaultSuffix) {
        return fileName.contains(".") ? fileName : fileName + defaultSuffix;
    }

    public abstract ContentIntent withDefaultHandlers(@NonNull Context var1);

    public I withHandlers(ContentHandler ... handlers) {
        return this.withHandlers(Arrays.asList(handlers));
    }

    public I withHandlers(@Nullable List<ContentHandler> handlers) {
        if (handlers != null) {
            if (this.mHandlers == null) {
                this.mHandlers = new ArrayList<ContentHandler>(handlers.size());
            }
            this.mHandlers.addAll(handlers);
        } else {
            this.mHandlers = null;
        }
        return (I)this;
    }

    public I withHandler(@NonNull ContentHandler handler) {
        if (this.mHandlers == null) {
            this.mHandlers = new ArrayList<ContentHandler>(1);
        }
        this.mHandlers.add(handler);
        return (I)this;
    }

    @NonNull
    public List<ContentHandler> handlers() {
        return this.mHandlers != null ? new ArrayList<ContentHandler>(this.mHandlers) : Collections.EMPTY_LIST;
    }

    public I input(@Nullable File file) {
        if (file != null) {
            this.input(Uri.fromFile((File)file));
        } else {
            this.input((Uri)null);
        }
        return (I)this;
    }

    public I input(@Nullable Uri uri) {
        this.mUri = uri;
        this.mDataType = null;
        this.mHasInputUri = uri != null;
        return (I)this;
    }

    public I output(@Nullable File file) {
        if (file != null) {
            this.output(Uri.fromFile((File)file));
        } else {
            this.output((Uri)null);
        }
        return (I)this;
    }

    public I output(@Nullable Uri uri) {
        this.mUri = uri;
        this.mDataType = null;
        this.mHasInputUri = false;
        return (I)this;
    }

    @Nullable
    public Uri uri() {
        return this.mUri;
    }

    public I dataType(@NonNull String type) {
        this.mDataType = type;
        return (I)this;
    }

    @Nullable
    public String dataType() {
        return this.mDataType;
    }

    @Override
    public boolean startWith(@NonNull IntentStarter starter) {
        Context context = starter.getContext();
        if (this.mHandlers != null && !this.mHandlers.isEmpty()) {
            this.onShowChooserDialog(starter);
            return true;
        }
        Intent intent = this.build(context);
        if (ContentIntent.isActivityForIntentAvailable(context, intent)) {
            return this.onStartWith(starter, intent);
        }
        this.notifyActivityNotFound(context);
        return false;
    }

    protected void onShowChooserDialog(final @NonNull IntentStarter starter) {
        int n = this.mHandlers.size();
        CharSequence[] providerNames = new CharSequence[n];
        for (int i = 0; i < n; ++i) {
            providerNames[i] = this.mHandlers.get((int)i).name;
        }
        AlertDialog.Builder builder = new AlertDialog.Builder(starter.getContext());
        builder.setTitle(this.mDialogTitle);
        builder.setItems(providerNames, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                ContentHandler handler = (ContentHandler)ContentIntent.this.mHandlers.get(which);
                if (handler.requestCode < 0) {
                    starter.startIntent(handler.intent);
                } else {
                    starter.startIntentForResult(handler.intent, handler.requestCode);
                }
            }
        });
        builder.show();
    }

    @Override
    @NonNull
    public Intent build(@NonNull Context context) {
        if (this.mHandlers != null && !this.mHandlers.isEmpty()) {
            throw new IllegalStateException("Cannot build intent for set of ContentHandlers.");
        }
        return super.build(context);
    }

    @Override
    protected void ensureCanBuildOrThrow() {
        super.ensureCanBuildOrThrow();
        if (!this.mHasInputUri) {
            throw this.cannotBuildIntentException("No input Uri specified.");
        }
        if (TextUtils.isEmpty((CharSequence)this.mDataType)) {
            throw this.cannotBuildIntentException("No MIME type specified for input Uri.");
        }
    }

    @Override
    @NonNull
    protected Intent onBuild(@NonNull Context context) {
        return new Intent("android.intent.action.VIEW").setDataAndType(this.mUri, this.mDataType);
    }

    @Override
    protected boolean onStartWith(@NonNull IntentStarter starter, @NonNull Intent intent) {
        return super.onStartWith(starter, Intent.createChooser((Intent)intent, (CharSequence)this.mDialogTitle));
    }

    public static class ContentHandler {
        final CharSequence name;
        final Intent intent;
        int requestCode = -1;

        public ContentHandler(@NonNull CharSequence name, @NonNull Intent intent) {
            this.name = name;
            this.intent = intent;
        }

        @NonNull
        public CharSequence name() {
            return this.name;
        }

        @NonNull
        public Intent intent() {
            return this.intent;
        }

        public ContentHandler requestCode(int code) {
            this.requestCode = code;
            return this;
        }

        public int requestCode() {
            return this.requestCode;
        }
    }
}

