/*
 * Decompiled with CFR 0.152.
 */
package universum.studios.android.intent;

import android.content.Context;
import android.content.Intent;
import android.support.annotation.AnimRes;
import android.support.annotation.CheckResult;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AndroidRuntimeException;
import android.widget.Toast;
import universum.studios.android.intent.IntentStarter;

public abstract class BaseIntent<I extends BaseIntent> {
    CharSequence mDialogTitle = "Choose";
    private CharSequence mActivityNotFoundMessage = "No application found to handle this action";
    private int mEnterTransition;
    private int mExitTransition;
    private boolean mApplyTransitions;

    public I dialogTitle(@Nullable CharSequence title) {
        this.mDialogTitle = title;
        return (I)this;
    }

    @NonNull
    public CharSequence dialogTitle() {
        return this.mDialogTitle != null ? this.mDialogTitle : "";
    }

    public I activityNotFoundMessage(@Nullable CharSequence message) {
        this.mActivityNotFoundMessage = message;
        return (I)this;
    }

    @NonNull
    public CharSequence activityNotFoundMessage() {
        return this.mActivityNotFoundMessage != null ? this.mActivityNotFoundMessage : "";
    }

    public I enterTransition(@AnimRes int transition) {
        return this.transitions(transition, this.mExitTransition);
    }

    @AnimRes
    public int enterTransition() {
        return this.mEnterTransition;
    }

    public I exitTransition(@AnimRes int transition) {
        return this.transitions(this.mEnterTransition, transition);
    }

    @AnimRes
    public int exitTransition() {
        return this.mExitTransition;
    }

    public I transitions(@AnimRes int enterTransition, @AnimRes int exitTransition) {
        if (enterTransition >= 0 || exitTransition >= 0) {
            this.mEnterTransition = enterTransition;
            this.mExitTransition = exitTransition;
            this.mApplyTransitions = true;
        } else {
            this.mApplyTransitions = false;
        }
        return (I)this;
    }

    public boolean startWith(@NonNull IntentStarter starter) {
        Intent intent;
        Context context = starter.getContext();
        if (BaseIntent.isActivityForIntentAvailable(context, intent = this.build(context))) {
            return this.onStartWith(starter, intent);
        }
        this.notifyActivityNotFound(context);
        return false;
    }

    @NonNull
    public Intent build(@NonNull Context context) {
        this.ensureCanBuildOrThrow();
        return this.onBuild(context);
    }

    protected void ensureCanBuildOrThrow() {
    }

    @NonNull
    protected abstract Intent onBuild(@NonNull Context var1);

    @CheckResult
    public static boolean isActivityForIntentAvailable(@NonNull Context context, @NonNull Intent intent) {
        return intent.resolveActivity(context.getPackageManager()) != null;
    }

    protected final AndroidRuntimeException cannotBuildIntentException(@NonNull String message) {
        return new AndroidRuntimeException("Cannot build " + this.getClass().getSimpleName() + ". " + message);
    }

    protected boolean onStartWith(@NonNull IntentStarter starter, @NonNull Intent intent) {
        starter.startIntent(intent);
        if (this.mApplyTransitions) {
            starter.overridePendingTransition(this.mEnterTransition, this.mExitTransition);
        }
        return true;
    }

    protected void notifyActivityNotFound(@NonNull Context context) {
        Toast.makeText((Context)context, (CharSequence)this.mActivityNotFoundMessage, (int)1).show();
    }
}

