/*
 * Decompiled with CFR 0.152.
 */
package universum.studios.android.imageloader;

import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.widget.ImageView;
import androidx.annotation.DrawableRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

public interface ImageLoader {
    public void start();

    public void resume();

    public void pause();

    public void stop();

    public void destroy();

    public boolean load(@NonNull Task var1, @Nullable Callback var2);

    @Nullable
    public Bitmap load(@NonNull Task var1);

    public boolean remove(@NonNull Task var1);

    public void onLowMemory();

    public void onTrimMemory(int var1);

    public static final class Error
    extends RuntimeException {
        public static final int REASON_UNKNOWN = 0;
        public static final int REASON_IO = 1;
        public static final int REASON_DECODING = 2;
        public static final int REASON_NETWORK = 3;
        public static final int REASON_MEMORY = 4;
        public final int reason;

        public Error(int reason, @NonNull String detailMessage) {
            this(reason, detailMessage, null);
        }

        public Error(int reason, @NonNull String detailMessage, @Nullable Throwable cause) {
            super(detailMessage, cause);
            this.reason = reason;
        }
    }

    public static interface Task<Target, Transformation> {
        public static final int NO_RESOURCE_ID = 0;

        public Task<Target, Transformation> target(@NonNull Target var1);

        @NonNull
        public Target target();

        public Task<Target, Transformation> placeholder(@DrawableRes int var1);

        public Task<Target, Transformation> placeholder(@Nullable Drawable var1);

        public Task<Target, Transformation> error(@DrawableRes int var1);

        public Task<Target, Transformation> error(@Nullable Drawable var1);

        public Task<Target, Transformation> transform(@Nullable Transformation var1);

        public Task<Target, Transformation> doNotAnimate(boolean var1);

        public Task<Target, Transformation> view(@NonNull ImageView var1);

        @Nullable
        public ImageView view();
    }

    public static interface Callback {
        public void onImageLoadFinished(@NonNull Task var1, @NonNull Bitmap var2);

        public void onImageLoadFailed(@NonNull Task var1, @NonNull Error var2);
    }
}

