/*
 * Decompiled with CFR 0.152.
 */
package universum.studios.android.graphics;

import android.graphics.Color;
import android.support.annotation.ColorInt;
import android.support.annotation.FloatRange;
import android.support.annotation.IntRange;
import android.support.annotation.NonNull;
import java.util.Random;

public final class Colors {
    private static final int COMPONENT_VALUE_MIN = 0;
    private static final int COMPONENT_VALUE_MAX = 255;
    private static final float RATIO_DEFAULT = 0.5f;

    private Colors() {
        throw new UnsupportedOperationException();
    }

    @ColorInt
    public static int withAlpha(@ColorInt int color, @FloatRange(from=0.0, to=1.0) float alphaRatio) {
        if ((double)alphaRatio < 0.0 || (double)alphaRatio > 1.0) {
            throw new IllegalArgumentException("Alpha ratio(" + alphaRatio + ") is out of [0.0, 1.0f] range.");
        }
        return Colors.withAlpha(color, (int)(alphaRatio * 255.0f));
    }

    @ColorInt
    public static int withAlpha(@ColorInt int color, @IntRange(from=0L, to=255L) int alpha) {
        if (alpha < 0 || alpha > 255) {
            throw new IllegalArgumentException("Alpha(" + alpha + ") is out of [0, 255] range.");
        }
        return Color.argb((int)alpha, (int)Color.red((int)color), (int)Color.green((int)color), (int)Color.blue((int)color));
    }

    @ColorInt
    public static int blend(@ColorInt int first, @ColorInt int second) {
        return Colors.blend(first, second, 0.5f);
    }

    @ColorInt
    public static int blend(@ColorInt int first, @ColorInt int second, @FloatRange(from=0.0, to=1.0) float blendingRatio) {
        if ((double)blendingRatio < 0.0 || (double)blendingRatio > 1.0) {
            throw new IllegalArgumentException("Blending ratio(" + blendingRatio + ") is out of [0.0, 1.0f] range.");
        }
        float fcRatio = blendingRatio;
        float scRatio = 1.0f - blendingRatio;
        int red = (int)((float)Color.red((int)first) * fcRatio + (float)Color.red((int)second) * scRatio);
        int green = (int)((float)Color.green((int)first) * fcRatio + (float)Color.green((int)second) * scRatio);
        int blue = (int)((float)Color.blue((int)first) * fcRatio + (float)Color.blue((int)second) * scRatio);
        int alpha = (int)((float)Color.alpha((int)first) * fcRatio + (float)Color.alpha((int)second) * scRatio);
        return Color.argb((int)alpha, (int)red, (int)green, (int)blue);
    }

    @ColorInt
    public static int brighter(@ColorInt int color, @FloatRange(from=0.0, to=1.0) float fraction) {
        if (fraction < 0.0f || fraction > 1.0f) {
            throw new IllegalArgumentException("Fraction(" + fraction + ") is out of [0.0, 1.0f] range.");
        }
        int red = (int)Math.round((double)Color.red((int)color) * (1.0 + (double)fraction));
        int green = (int)Math.round((double)Color.green((int)color) * (1.0 + (double)fraction));
        int blue = (int)Math.round((double)Color.blue((int)color) * (1.0 + (double)fraction));
        return Color.argb((int)Color.alpha((int)color), (int)Colors.ensureThatComponentValueIsInAllowedInterval(red), (int)Colors.ensureThatComponentValueIsInAllowedInterval(green), (int)Colors.ensureThatComponentValueIsInAllowedInterval(blue));
    }

    @ColorInt
    public static int darker(@ColorInt int color, @FloatRange(from=0.0, to=1.0) float fraction) {
        if (fraction < 0.0f || fraction > 1.0f) {
            throw new IllegalArgumentException("Fraction(" + fraction + ") is out of [0.0, 1.0f] range.");
        }
        int red = (int)Math.round((double)Color.red((int)color) * (1.0 - (double)fraction));
        int green = (int)Math.round((double)Color.green((int)color) * (1.0 - (double)fraction));
        int blue = (int)Math.round((double)Color.blue((int)color) * (1.0 - (double)fraction));
        return Color.argb((int)Color.alpha((int)color), (int)Colors.ensureThatComponentValueIsInAllowedInterval(red), (int)Colors.ensureThatComponentValueIsInAllowedInterval(green), (int)Colors.ensureThatComponentValueIsInAllowedInterval(blue));
    }

    private static int ensureThatComponentValueIsInAllowedInterval(int value) {
        return Math.max(0, Math.min(255, value));
    }

    @ColorInt
    public static int random(boolean randomAlpha) {
        Random rand = new Random();
        return Color.argb((int)(randomAlpha ? rand.nextInt(256) : 255), (int)rand.nextInt(256), (int)rand.nextInt(256), (int)rand.nextInt(256));
    }

    @NonNull
    public static String hexName(@ColorInt int color) {
        return Colors.hexName(color, true);
    }

    @NonNull
    public static String hexName(@ColorInt int color, boolean withAlpha) {
        String name = withAlpha ? Colors.createComponentValueHexName(Color.alpha((int)color)) : "";
        name = name + Colors.createComponentValueHexName(Color.red((int)color));
        name = name + Colors.createComponentValueHexName(Color.green((int)color));
        name = name + Colors.createComponentValueHexName(Color.blue((int)color));
        return "#" + name;
    }

    private static String createComponentValueHexName(int value) {
        String valueAsString = Integer.toString(value, 16);
        return valueAsString.length() == 2 ? valueAsString : "0" + valueAsString;
    }
}

