/*
 * Decompiled with CFR 0.152.
 */
package universum.studios.android.fragment.annotation.handler;

import androidx.annotation.ColorRes;
import androidx.annotation.DrawableRes;
import androidx.annotation.LayoutRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import universum.studios.android.fragment.annotation.ContentView;
import universum.studios.android.fragment.annotation.handler.AnnotationHandlers;
import universum.studios.android.fragment.annotation.handler.BaseAnnotationHandler;
import universum.studios.android.fragment.annotation.handler.FragmentAnnotationHandler;

public final class BaseAnnotationHandlers
extends AnnotationHandlers {
    @Nullable
    public static FragmentAnnotationHandler obtainFragmentHandler(@NonNull Class<?> classOfFragment) {
        return BaseAnnotationHandlers.obtainHandler(FragmentHandler.class, classOfFragment);
    }

    static class FragmentHandler
    extends BaseAnnotationHandler
    implements FragmentAnnotationHandler {
        private boolean attachContentViewToContainer;
        private int contentViewResource = 0;
        private int contentViewBackgroundResId = 0;

        public FragmentHandler(@NonNull Class<?> annotatedClass) {
            super(annotatedClass);
            ContentView contentView = this.findAnnotation(ContentView.class);
            if (contentView != null) {
                this.attachContentViewToContainer = contentView.attachToContainer();
                this.contentViewResource = contentView.value();
                this.contentViewBackgroundResId = contentView.background();
            }
        }

        @Override
        @LayoutRes
        public int getContentViewResource(@LayoutRes int defaultViewResource) {
            return this.contentViewResource == 0 ? defaultViewResource : this.contentViewResource;
        }

        @Override
        public boolean shouldAttachContentViewToContainer() {
            return this.attachContentViewToContainer;
        }

        @Override
        @ColorRes
        @DrawableRes
        public int getContentViewBackgroundResId(int defaultResId) {
            return this.contentViewBackgroundResId == 0 ? defaultResId : this.contentViewBackgroundResId;
        }
    }
}

