/*
 * Decompiled with CFR 0.152.
 */
package universum.studios.android.fragment.util;

import android.annotation.SuppressLint;
import android.content.ContentResolver;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.PowerManager;
import android.provider.Settings;
import android.transition.Transition;
import android.transition.TransitionInflater;
import android.transition.TransitionManager;
import android.view.ViewGroup;
import androidx.annotation.DrawableRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import androidx.vectordrawable.graphics.drawable.VectorDrawableCompat;
import universum.studios.android.fragment.FragmentPolicies;

public final class FragmentUtils {
    @VisibleForTesting
    static final boolean ACCESS_LOLLIPOP = Build.VERSION.SDK_INT >= 21;

    private FragmentUtils() {
        throw new UnsupportedOperationException();
    }

    public static boolean willBeCustomAnimationsPlayed(@NonNull Context context) {
        return !FragmentUtils.isPowerSaveModeActive(context) && FragmentUtils.areAnimationsEnabled(context);
    }

    public static boolean isPowerSaveModeActive(@NonNull Context context) {
        if (Build.VERSION.SDK_INT >= 21) {
            PowerManager powerManager = (PowerManager)context.getSystemService("power");
            return powerManager != null && powerManager.isPowerSaveMode();
        }
        return false;
    }

    public static boolean areAnimationsEnabled(@NonNull Context context) {
        float animatorDurationScale = -1.0f;
        if (Build.VERSION.SDK_INT >= 17) {
            animatorDurationScale = Settings.Global.getFloat((ContentResolver)context.getContentResolver(), (String)"animator_duration_scale", (float)animatorDurationScale);
        } else if (Build.VERSION.SDK_INT >= 16) {
            animatorDurationScale = Settings.System.getFloat((ContentResolver)context.getContentResolver(), (String)"animator_duration_scale", (float)animatorDurationScale);
        }
        return animatorDurationScale == -1.0f || animatorDurationScale > 0.0f;
    }

    @SuppressLint(value={"NewApi"})
    @Nullable
    public static Transition inflateTransition(@NonNull Context context, int resource) {
        return FragmentPolicies.TRANSITIONS_SUPPORTED && context.getResources() != null ? TransitionInflater.from((Context)context).inflateTransition(resource) : null;
    }

    @SuppressLint(value={"NewApi"})
    @Nullable
    public static TransitionManager inflateTransitionManager(@NonNull Context context, int resource, @NonNull ViewGroup sceneRoot) {
        return FragmentPolicies.TRANSITIONS_SUPPORTED && context.getResources() != null ? TransitionInflater.from((Context)context).inflateTransitionManager(resource, sceneRoot) : null;
    }

    @Nullable
    public static Drawable getVectorDrawable(@NonNull Resources resources, @DrawableRes int resId, @Nullable Resources.Theme theme) throws Resources.NotFoundException {
        if (resId == 0) {
            return null;
        }
        return ACCESS_LOLLIPOP ? FragmentUtils.getDrawable(resources, resId, theme) : VectorDrawableCompat.create((Resources)resources, (int)resId, (Resources.Theme)theme);
    }

    @Nullable
    public static Drawable getDrawable(@NonNull Resources resources, @DrawableRes int resId, @Nullable Resources.Theme theme) throws Resources.NotFoundException {
        if (resId == 0) {
            return null;
        }
        return ACCESS_LOLLIPOP ? resources.getDrawable(resId, theme) : resources.getDrawable(resId);
    }
}

