/*
 * Decompiled with CFR 0.152.
 */
package universum.studios.android.fragment;

import android.app.ActionBar;
import android.app.Activity;
import android.os.Bundle;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import androidx.annotation.CallSuper;
import androidx.annotation.LayoutRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import androidx.appcompat.view.ActionMode;
import universum.studios.android.fragment.ActionBarDelegate;
import universum.studios.android.fragment.BaseFragment;
import universum.studios.android.fragment.annotation.FragmentAnnotations;
import universum.studios.android.fragment.annotation.handler.ActionBarAnnotationHandlers;
import universum.studios.android.fragment.annotation.handler.ActionBarFragmentAnnotationHandler;

public class ActionBarFragment
extends BaseFragment {
    private ActionMode actionMode;
    @VisibleForTesting
    ActionBarDelegate actionBarDelegate;

    public ActionBarFragment() {
        this(0);
    }

    public ActionBarFragment(@LayoutRes int contentLayoutId) {
        super(contentLayoutId);
    }

    @Override
    ActionBarFragmentAnnotationHandler onCreateAnnotationHandler() {
        return ActionBarAnnotationHandlers.obtainActionBarFragmentHandler(this.getClass());
    }

    @Override
    @NonNull
    protected ActionBarFragmentAnnotationHandler getAnnotationHandler() {
        FragmentAnnotations.checkIfEnabledOrThrow();
        return (ActionBarFragmentAnnotationHandler)this.annotationHandler;
    }

    @Override
    public void onCreate(@Nullable Bundle savedInstanceState) {
        ActionBarFragmentAnnotationHandler annotationHandler;
        super.onCreate(savedInstanceState);
        if (this.annotationHandler != null && (annotationHandler = (ActionBarFragmentAnnotationHandler)this.annotationHandler).hasOptionsMenu()) {
            this.setHasOptionsMenu(true);
        }
    }

    public void onCreateOptionsMenu(@NonNull Menu menu, @NonNull MenuInflater inflater) {
        if (this.annotationHandler == null) {
            super.onCreateOptionsMenu(menu, inflater);
            return;
        }
        ActionBarFragmentAnnotationHandler annotationHandler = (ActionBarFragmentAnnotationHandler)this.annotationHandler;
        if (annotationHandler.hasOptionsMenu()) {
            int menuResource;
            if (annotationHandler.shouldClearOptionsMenu()) {
                menu.clear();
            }
            if ((menuResource = annotationHandler.getOptionsMenuResource(0)) == 0) {
                super.onCreateOptionsMenu(menu, inflater);
            } else {
                switch (annotationHandler.getOptionsMenuFlags(0)) {
                    case 1: {
                        inflater.inflate(menuResource, menu);
                        break;
                    }
                    case 2: {
                        inflater.inflate(menuResource, menu);
                        super.onCreateOptionsMenu(menu, inflater);
                        break;
                    }
                    default: {
                        super.onCreateOptionsMenu(menu, inflater);
                        inflater.inflate(menuResource, menu);
                    }
                }
            }
        } else {
            super.onCreateOptionsMenu(menu, inflater);
        }
    }

    public void onActivityCreated(@Nullable Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
        this.actionBarDelegate = ActionBarDelegate.create((Activity)this.requireActivity());
        this.invalidateActionBar();
    }

    protected final boolean isActionBarAvailable() {
        return this.actionBarDelegate != null;
    }

    @NonNull
    protected ActionBarDelegate getActionBarDelegate() {
        if (this.actionBarDelegate == null) {
            throw new IllegalStateException("The parent activity does not have ActionBar presented!");
        }
        return this.actionBarDelegate;
    }

    @Nullable
    protected ActionBar getActionBar() {
        if (this.activityDelegate == null) {
            throw new IllegalStateException("Cannot access ActionBar. " + this.getClass() + " is not attached to the parent activity yet or it has been already detached!");
        }
        return this.activityDelegate.getActionBar();
    }

    @Nullable
    protected androidx.appcompat.app.ActionBar getSupportActionBar() {
        if (this.activityDelegate == null) {
            throw new IllegalStateException("Cannot access support ActionBar. " + this.getClass() + " is not attached to the parent activity yet or it has been already detached!");
        }
        return this.activityDelegate.getSupportActionBar();
    }

    public void invalidateActionBar() {
        if (this.actionBarDelegate != null && this.annotationHandler != null) {
            ActionBarFragmentAnnotationHandler annotationHandler = (ActionBarFragmentAnnotationHandler)this.annotationHandler;
            annotationHandler.configureActionBar(this.actionBarDelegate);
            if (annotationHandler.hasOptionsMenu()) {
                this.setHasOptionsMenu(true);
            }
        }
    }

    protected boolean startActionMode() {
        return this.startActionMode(new ActionModeCallback(this));
    }

    protected boolean startActionMode(@NonNull ActionMode.Callback callback) {
        ActionMode actionMode;
        if (!this.isInActionMode() && this.activityDelegate != null && (actionMode = this.activityDelegate.startActionMode(callback)) != null) {
            this.onActionModeStarted(actionMode);
            return true;
        }
        return false;
    }

    @CallSuper
    protected void onActionModeStarted(@NonNull ActionMode actionMode) {
        this.actionMode = actionMode;
    }

    protected boolean isInActionMode() {
        return this.actionMode != null;
    }

    @Nullable
    protected ActionMode getActionMode() {
        return this.actionMode;
    }

    protected boolean finishActionMode() {
        if (this.actionMode != null) {
            this.actionMode.finish();
            return true;
        }
        return false;
    }

    @CallSuper
    protected void onActionModeFinished() {
        this.actionMode = null;
    }

    @Override
    protected boolean onBackPress() {
        return this.finishActionMode() || super.onBackPress();
    }

    public static class ActionModeCallback
    implements ActionMode.Callback {
        protected final ActionBarFragment fragment;

        public ActionModeCallback() {
            this(null);
        }

        public ActionModeCallback(@Nullable ActionBarFragment fragment) {
            this.fragment = fragment;
        }

        public boolean onCreateActionMode(@NonNull ActionMode actionMode, @NonNull Menu menu) {
            if (this.fragment == null || !FragmentAnnotations.isEnabled()) {
                return false;
            }
            return this.fragment.getAnnotationHandler().handleCreateActionMode(actionMode, menu);
        }

        public boolean onPrepareActionMode(@NonNull ActionMode actionMode, @NonNull Menu menu) {
            return false;
        }

        public boolean onActionItemClicked(@NonNull ActionMode actionMode, @NonNull MenuItem menuItem) {
            if (this.fragment != null && this.fragment.onOptionsItemSelected(menuItem)) {
                actionMode.finish();
                return true;
            }
            return false;
        }

        public void onDestroyActionMode(@NonNull ActionMode actionMode) {
            if (this.fragment != null) {
                this.fragment.onActionModeFinished();
            }
        }
    }
}

