/*
 * Decompiled with CFR 0.152.
 */
package universum.studios.android.fragment.manage;

import android.content.Context;
import android.view.View;
import androidx.annotation.IdRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import androidx.core.util.Pair;
import androidx.core.view.ViewCompat;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import androidx.fragment.app.FragmentManager;
import androidx.fragment.app.FragmentTransaction;
import androidx.lifecycle.Lifecycle;
import java.util.ArrayList;
import java.util.List;
import universum.studios.android.fragment.FragmentsLogging;
import universum.studios.android.fragment.manage.FragmentFactory;
import universum.studios.android.fragment.manage.FragmentRequest;
import universum.studios.android.fragment.manage.FragmentRequestInterceptor;
import universum.studios.android.fragment.util.FragmentUtils;

public class FragmentController {
    private static final String TAG = "FragmentController";
    public static final String FRAGMENT_TAG = "universum.studios.android.fragment.TAG.Fragment";
    public static final int NO_CONTAINER_ID = -1;
    private final FragmentManager.OnBackStackChangedListener backStackChangeListener;
    final FragmentManager manager;
    @VisibleForTesting
    Context context;
    @VisibleForTesting
    Lifecycle lifecycle;
    private Lifecycle.State lifecycleRequiredState = Lifecycle.State.STARTED;
    private int viewContainerId = -1;
    private FragmentFactory factory;
    private FragmentRequestInterceptor requestInterceptor;
    private List<OnRequestListener> requestListeners;
    private List<OnBackStackChangeListener> backStackChangeListeners;
    private FragmentManager.BackStackEntry topBackStackEntry;
    private boolean destroyed;

    @Deprecated
    public FragmentController(@NonNull FragmentActivity parentActivity) {
        this((Context)parentActivity, parentActivity.getSupportFragmentManager());
        this.setLifecycle(parentActivity.getLifecycle());
        if (parentActivity instanceof FragmentRequestInterceptor) {
            this.setRequestInterceptor((FragmentRequestInterceptor)parentActivity);
        }
        if (parentActivity instanceof OnRequestListener) {
            this.registerOnRequestListener((OnRequestListener)parentActivity);
        }
        if (parentActivity instanceof OnBackStackChangeListener) {
            this.registerOnBackStackChangeListener((OnBackStackChangeListener)parentActivity);
        }
    }

    @Deprecated
    public FragmentController(@NonNull Fragment parentFragment) {
        this((Context)parentFragment.getActivity(), parentFragment.requireFragmentManager());
        this.setLifecycle(parentFragment.getLifecycle());
        if (parentFragment instanceof FragmentRequestInterceptor) {
            this.setRequestInterceptor((FragmentRequestInterceptor)parentFragment);
        }
        if (parentFragment instanceof OnRequestListener) {
            this.registerOnRequestListener((OnRequestListener)parentFragment);
        }
        if (parentFragment instanceof OnBackStackChangeListener) {
            this.registerOnBackStackChangeListener((OnBackStackChangeListener)parentFragment);
        }
    }

    public FragmentController(@NonNull FragmentManager fragmentManager) {
        this(null, fragmentManager);
    }

    public FragmentController(@Nullable Context context, @NonNull FragmentManager fragmentManager) {
        this.context = context;
        this.manager = fragmentManager;
        this.backStackChangeListener = new BackStackListener(this);
        this.manager.addOnBackStackChangedListener(this.backStackChangeListener);
        int n = this.manager.getBackStackEntryCount();
        if (n > 0) {
            this.topBackStackEntry = this.manager.getBackStackEntryAt(n - 1);
        }
    }

    public static FragmentController create(@NonNull FragmentActivity activity) {
        return new FragmentController(activity);
    }

    public static FragmentController create(@NonNull Fragment fragment) {
        return new FragmentController(fragment);
    }

    @NonNull
    public FragmentManager getFragmentManager() {
        return this.manager;
    }

    public void setLifecycle(@Nullable Lifecycle lifecycle) {
        this.lifecycle = lifecycle;
    }

    public void setLifecycleRequiredState(@NonNull Lifecycle.State requiredState) {
        this.lifecycleRequiredState = requiredState;
    }

    @NonNull
    public Lifecycle.State getLifecycleRequiredState() {
        return this.lifecycleRequiredState;
    }

    public void setViewContainerId(@IdRes int containerId) {
        this.viewContainerId = containerId;
    }

    @IdRes
    public int getViewContainerId() {
        return this.viewContainerId;
    }

    public void setFactory(@Nullable FragmentFactory factory) {
        this.factory = factory;
    }

    public boolean hasFactory() {
        return this.factory != null;
    }

    private void assertHasFactory() {
        if (this.factory == null) {
            throw new IllegalStateException("No factory attached!");
        }
    }

    @Nullable
    public FragmentFactory getFactory() {
        return this.factory;
    }

    public void setRequestInterceptor(@Nullable FragmentRequestInterceptor interceptor) {
        this.requestInterceptor = interceptor;
    }

    public void registerOnRequestListener(@NonNull OnRequestListener listener) {
        if (this.requestListeners == null) {
            this.requestListeners = new ArrayList<OnRequestListener>(1);
        }
        if (!this.requestListeners.contains(listener)) {
            this.requestListeners.add(listener);
        }
    }

    @VisibleForTesting
    void notifyRequestExecuted(FragmentRequest request) {
        if (this.requestListeners != null && !this.requestListeners.isEmpty()) {
            for (OnRequestListener listener : this.requestListeners) {
                listener.onRequestExecuted(request);
            }
        }
    }

    public void unregisterOnRequestListener(@NonNull OnRequestListener listener) {
        if (this.requestListeners != null) {
            this.requestListeners.remove(listener);
        }
    }

    public void registerOnBackStackChangeListener(@NonNull OnBackStackChangeListener listener) {
        if (this.backStackChangeListeners == null) {
            this.backStackChangeListeners = new ArrayList<OnBackStackChangeListener>(1);
        }
        if (!this.backStackChangeListeners.contains(listener)) {
            this.backStackChangeListeners.add(listener);
        }
    }

    @VisibleForTesting
    void notifyBackStackEntryChange(FragmentManager.BackStackEntry changedEntry, boolean added) {
        if (this.backStackChangeListeners != null && !this.backStackChangeListeners.isEmpty()) {
            for (OnBackStackChangeListener listener : this.backStackChangeListeners) {
                listener.onFragmentsBackStackChanged(changedEntry, added);
            }
        }
    }

    public void unregisterOnBackStackChangeListener(@NonNull OnBackStackChangeListener listener) {
        if (this.backStackChangeListeners != null) {
            this.backStackChangeListeners.remove(listener);
        }
    }

    @NonNull
    public final FragmentRequest newRequest() {
        this.assertNotDestroyed("NEW REQUEST");
        return new FragmentRequest(this, null).viewContainerId(this.viewContainerId);
    }

    @NonNull
    public final FragmentRequest newRequest(@NonNull Fragment fragment) {
        this.assertNotDestroyed("NEW REQUEST");
        return new FragmentRequest(this, fragment).tag(FRAGMENT_TAG).viewContainerId(this.viewContainerId);
    }

    @NonNull
    public final FragmentRequest newRequest(int fragmentId) {
        this.assertNotDestroyed("NEW REQUEST");
        return new FragmentRequest(this, fragmentId).viewContainerId(this.viewContainerId);
    }

    @Nullable
    Fragment executeRequest(FragmentRequest request) {
        Lifecycle.State lifecycleCurrentState;
        this.assertNotDestroyed("EXECUTE REQUEST");
        Lifecycle.State state = lifecycleCurrentState = this.lifecycle == null ? null : this.lifecycle.getCurrentState();
        if (!request.hasFlag(16) && lifecycleCurrentState != null && !lifecycleCurrentState.isAtLeast(this.lifecycleRequiredState)) {
            FragmentsLogging.w(TAG, "Current Lifecycle's state(" + lifecycleCurrentState + ") is not at least(" + this.lifecycleRequiredState + "). Ignoring request!");
            return null;
        }
        Fragment fragment = request.fragment;
        if (fragment == null) {
            String fragmentTag = request.tag;
            int fragmentId = request.fragmentId;
            if (fragmentId == -1) {
                switch (request.transaction) {
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: {
                        fragment = this.manager.findFragmentByTag(fragmentTag);
                        break;
                    }
                }
            } else {
                this.assertHasFactory();
                if (!this.factory.isFragmentProvided(fragmentId)) {
                    throw new IllegalArgumentException("Cannot execute request for factory fragment. Current factory(" + this.factory.getClass() + ") does not provide fragment for the requested id(" + fragmentId + ")!");
                }
                if (fragmentTag == null) {
                    fragmentTag = this.factory.createFragmentTag(fragmentId);
                }
                switch (request.transaction) {
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: {
                        fragment = this.manager.findFragmentByTag(fragmentTag);
                        break;
                    }
                    default: {
                        fragment = this.factory.createFragment(fragmentId);
                        if (fragment != null) break;
                        throw new IllegalArgumentException("Cannot execute request for factory fragment. Current factory(" + this.factory.getClass() + ") is cheating. FragmentFactory.isFragmentProvided(...) returned true, but FragmentFactory.createFragment(...) returned null!");
                    }
                }
                request.tag = fragmentTag;
            }
        }
        if ((request.fragment = fragment) == null) {
            return null;
        }
        Fragment fragment2 = fragment = this.requestInterceptor == null ? null : this.requestInterceptor.interceptFragmentRequest(request);
        if (fragment == null) {
            fragment = this.onExecuteRequest(request);
        }
        this.notifyRequestExecuted(request);
        return fragment;
    }

    @NonNull
    protected Fragment onExecuteRequest(@NonNull FragmentRequest request) {
        Fragment existingFragment;
        if (this.manager.isDestroyed()) {
            throw new IllegalStateException("Cannot execute fragment request in context of activity that has been already destroyed!");
        }
        if (request.transaction == 0 && !request.hasFlag(1) && (existingFragment = this.manager.findFragmentByTag(request.tag)) != null) {
            FragmentsLogging.d(TAG, "Fragment with tag(" + request.tag + ") is already displayed or it is in the back-stack.");
            return existingFragment;
        }
        Fragment fragment = request.fragment;
        FragmentTransaction transaction = this.createTransaction(request);
        if (request.hasFlag(2)) {
            FragmentsLogging.d(TAG, "Fragment(" + fragment + ") will be added into back-stack under the tag(" + fragment.getTag() + ").");
        }
        boolean now = request.hasFlag(8);
        if (request.hasFlag(4)) {
            if (now) {
                transaction.commitNowAllowingStateLoss();
            } else {
                transaction.commitAllowingStateLoss();
            }
        } else if (now) {
            transaction.commitNow();
        } else {
            transaction.commit();
        }
        return fragment;
    }

    @NonNull
    public FragmentTransaction createTransaction(@NonNull FragmentRequest request) {
        this.assertNotDestroyed("CREATE TRANSACTION");
        FragmentTransaction transaction = this.manager.beginTransaction();
        Fragment fragment = request.fragment;
        if (request.arguments != null) {
            fragment.setArguments(request.arguments);
        }
        if (request.transition != null) {
            if (this.context == null || FragmentUtils.willBeCustomAnimationsPlayed(this.context)) {
                transaction.setCustomAnimations(request.transition.getIncomingAnimation(), request.transition.getOutgoingAnimation(), request.transition.getIncomingBackStackAnimation(), request.transition.getOutgoingBackStackAnimation());
            }
        } else if (request.transitionStyle != -1) {
            transaction.setTransitionStyle(request.transitionStyle);
        }
        switch (request.transaction) {
            case 0: {
                if (request.viewContainerId == -1) {
                    throw new IllegalArgumentException("Cannot create REPLACE transaction. No view container id specified!");
                }
                transaction.replace(request.viewContainerId, fragment, request.tag);
                break;
            }
            case 1: {
                if (request.viewContainerId == -1) {
                    throw new IllegalArgumentException("Cannot create ADD transaction. No view container id specified!");
                }
                transaction.add(request.viewContainerId, fragment, request.tag);
                break;
            }
            case 2: {
                transaction.remove(fragment);
                break;
            }
            case 3: {
                transaction.show(fragment);
                break;
            }
            case 4: {
                transaction.hide(fragment);
                break;
            }
            case 5: {
                transaction.attach(fragment);
                break;
            }
            case 6: {
                transaction.detach(fragment);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported transaction type(" + request.transaction + ") specified for the fragment request!");
            }
        }
        FragmentController.attachTransitionsToFragment(request, fragment);
        if (request.sharedElements != null && !request.sharedElements.isEmpty()) {
            List<Pair<View, String>> elements = request.sharedElements;
            for (Pair<View, String> pair : elements) {
                if (pair.first == null || pair.second == null) {
                    FragmentsLogging.i(TAG, "Skipping invalid shared element pair(view: " + pair.first + ", name: " + (String)pair.second + ").");
                    continue;
                }
                if (ViewCompat.getTransitionName((View)((View)pair.first)) == null) {
                    ViewCompat.setTransitionName((View)((View)pair.first), (String)((String)pair.second));
                }
                transaction.addSharedElement((View)pair.first, (String)pair.second);
            }
        }
        if (request.hasFlag(2)) {
            transaction.addToBackStack(fragment.getTag());
        }
        return transaction;
    }

    @VisibleForTesting
    static void attachTransitionsToFragment(FragmentRequest request, Fragment fragment) {
        if (request.hasTransition(1)) {
            fragment.setEnterTransition(request.enterTransition);
        }
        if (request.hasTransition(2)) {
            fragment.setExitTransition(request.exitTransition);
        }
        if (request.hasTransition(4)) {
            fragment.setReenterTransition(request.reenterTransition);
        }
        if (request.hasTransition(8)) {
            fragment.setReturnTransition(request.returnTransition);
        }
        if (request.hasTransition(16)) {
            fragment.setSharedElementEnterTransition(request.sharedElementEnterTransition);
        }
        if (request.hasTransition(32)) {
            fragment.setSharedElementReturnTransition(request.sharedElementReturnTransition);
        }
        if (request.allowEnterTransitionOverlap != null) {
            fragment.setAllowEnterTransitionOverlap(request.allowEnterTransitionOverlap.booleanValue());
        }
        if (request.allowReturnTransitionOverlap != null) {
            fragment.setAllowReturnTransitionOverlap(request.allowReturnTransitionOverlap.booleanValue());
        }
    }

    @Nullable
    public Fragment findCurrentFragment() {
        this.assertNotDestroyed("FIND CURRENT FRAGMENT");
        if (this.viewContainerId == -1) {
            throw new UnsupportedOperationException("Cannot find current fragment. No fragment container id specified!");
        }
        return this.manager.findFragmentById(this.viewContainerId);
    }

    @Nullable
    public Fragment findFragmentByFactoryId(int factoryFragmentId) {
        this.assertNotDestroyed("FIND FRAGMENT BY FACTORY ID");
        this.assertHasFactory();
        if (!this.factory.isFragmentProvided(factoryFragmentId)) {
            throw new IllegalArgumentException("Cannot find fragment by factory id. Current factory(" + this.factory.getClass() + ") does not provide fragment for the requested id(" + factoryFragmentId + ")!");
        }
        return this.manager.findFragmentByTag(this.factory.createFragmentTag(factoryFragmentId));
    }

    public boolean hasBackStackEntries() {
        return this.manager.getBackStackEntryCount() > 0;
    }

    @Nullable
    public FragmentManager.BackStackEntry getTopBackStackEntry() {
        return this.topBackStackEntry;
    }

    public void clearBackStack() {
        this.assertNotDestroyed("CLEAR BACK STACK");
        int n = this.manager.getBackStackEntryCount();
        for (int i = 0; i < n; ++i) {
            this.manager.popBackStack();
        }
    }

    public boolean clearBackStackImmediate() {
        this.assertNotDestroyed("CLEAR BACK STACK IMMEDIATE");
        boolean popped = false;
        int n = this.manager.getBackStackEntryCount();
        for (int i = 0; i < n; ++i) {
            if (!this.manager.popBackStackImmediate() || popped) continue;
            popped = true;
        }
        return popped;
    }

    public final void destroy() {
        if (!this.destroyed) {
            this.destroyed = true;
            this.manager.removeOnBackStackChangedListener(this.backStackChangeListener);
            this.requestListeners = null;
            this.backStackChangeListeners = null;
            this.lifecycle = null;
            this.context = null;
        }
    }

    private void assertNotDestroyed(String forAction) {
        if (this.destroyed) {
            throw new IllegalStateException("Cannot perform " + forAction + " action. Controller is already destroyed!");
        }
    }

    void handleBackStackChange(int backStackSize, int change) {
        switch (change) {
            case 0: {
                FragmentManager.BackStackEntry entry;
                this.topBackStackEntry = entry = this.manager.getBackStackEntryAt(backStackSize - 1);
                this.notifyBackStackEntryChange(this.topBackStackEntry, true);
                break;
            }
            default: {
                if (this.topBackStackEntry != null) {
                    this.notifyBackStackEntryChange(this.topBackStackEntry, false);
                }
                this.topBackStackEntry = backStackSize > 0 ? this.manager.getBackStackEntryAt(backStackSize - 1) : null;
            }
        }
    }

    static final class BackStackListener
    implements FragmentManager.OnBackStackChangedListener {
        static final int ADDED = 0;
        static final int REMOVED = 1;
        final FragmentController controller;
        int backStackSize;

        BackStackListener(FragmentController controller) {
            this.controller = controller;
        }

        public void onBackStackChanged() {
            int n = this.controller.getFragmentManager().getBackStackEntryCount();
            if (n >= 0 && n != this.backStackSize) {
                this.controller.handleBackStackChange(n, n > this.backStackSize ? 0 : 1);
                this.backStackSize = n;
            }
        }
    }

    public static interface OnBackStackChangeListener {
        public void onFragmentsBackStackChanged(@NonNull FragmentManager.BackStackEntry var1, boolean var2);
    }

    public static interface OnRequestListener {
        public void onRequestExecuted(@NonNull FragmentRequest var1);
    }
}

