/*
 * Decompiled with CFR 0.152.
 */
package universum.studios.android.fragment.manage;

import android.text.TextUtils;
import android.util.SparseArray;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import universum.studios.android.fragment.annotation.FragmentAnnotations;
import universum.studios.android.fragment.annotation.handler.BaseManagementAnnotationHandlers;
import universum.studios.android.fragment.annotation.handler.FragmentFactoryAnnotationHandler;
import universum.studios.android.fragment.manage.FragmentFactory;
import universum.studios.android.fragment.manage.FragmentItem;

public abstract class BaseFragmentFactory
implements FragmentFactory {
    private final FragmentFactoryAnnotationHandler annotationHandler = this.onCreateAnnotationHandler();
    private final SparseArray<FragmentItem> items = this.annotationHandler == null ? null : this.annotationHandler.getFragmentItems();
    private int lastCheckedFragmentId = -1;
    private boolean fragmentProvided;

    @Nullable
    public static String createFragmentTag(@NonNull Class<?> classOfFactory, @NonNull String fragmentName) {
        if (TextUtils.isEmpty((CharSequence)fragmentName)) {
            return null;
        }
        return classOfFactory.getName() + ".TAG." + fragmentName;
    }

    private FragmentFactoryAnnotationHandler onCreateAnnotationHandler() {
        return BaseManagementAnnotationHandlers.obtainFactoryHandler(this.getClass());
    }

    @NonNull
    protected FragmentFactoryAnnotationHandler getAnnotationHandler() {
        FragmentAnnotations.checkIfEnabledOrThrow();
        return this.annotationHandler;
    }

    @Override
    public boolean isFragmentProvided(int fragmentId) {
        if (fragmentId == this.lastCheckedFragmentId) {
            return this.fragmentProvided;
        }
        this.lastCheckedFragmentId = fragmentId;
        this.fragmentProvided = this.providesFragment(fragmentId);
        return this.fragmentProvided;
    }

    protected boolean providesFragment(int fragmentId) {
        return this.items != null && this.items.indexOfKey(fragmentId) >= 0;
    }

    @Override
    @Nullable
    public Fragment createFragment(int fragmentId) {
        return this.isFragmentProvided(fragmentId) ? this.onCreateFragment(fragmentId) : null;
    }

    @NonNull
    protected Fragment onCreateFragment(int fragmentId) {
        if (this.items.indexOfKey(fragmentId) < 0) {
            throw new IllegalArgumentException("Factory does not provide fragment instance for id(" + fragmentId + ")!");
        }
        Fragment fragment = ((FragmentItem)this.items.get(fragmentId)).newFragmentInstance(null);
        if (fragment == null) {
            throw new IllegalArgumentException("Failed to instantiate fragment for the requested id(" + fragmentId + ")!");
        }
        return fragment;
    }

    @Override
    @Nullable
    public String createFragmentTag(int fragmentId) {
        return this.isFragmentProvided(fragmentId) ? this.onCreateFragmentTag(fragmentId) : null;
    }

    @Nullable
    protected String onCreateFragmentTag(int fragmentId) {
        return this.items.indexOfKey(fragmentId) >= 0 ? ((FragmentItem)this.items.get((int)fragmentId)).tag : BaseFragmentFactory.createFragmentTag(this.getClass(), Integer.toString(fragmentId));
    }
}

