/*
 * Decompiled with CFR 0.152.
 */
package universum.studios.android.fragment.annotation.handler;

import android.text.TextUtils;
import android.util.Log;
import android.util.SparseArray;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import java.lang.reflect.Field;
import universum.studios.android.fragment.annotation.FactoryFragment;
import universum.studios.android.fragment.annotation.FactoryFragments;
import universum.studios.android.fragment.annotation.FragmentAnnotations;
import universum.studios.android.fragment.annotation.handler.AnnotationHandlers;
import universum.studios.android.fragment.annotation.handler.BaseAnnotationHandler;
import universum.studios.android.fragment.annotation.handler.FragmentFactoryAnnotationHandler;
import universum.studios.android.fragment.manage.BaseFragmentFactory;
import universum.studios.android.fragment.manage.FragmentItem;

public final class BaseManagementAnnotationHandlers
extends AnnotationHandlers {
    @Nullable
    public static FragmentFactoryAnnotationHandler obtainFactoryHandler(@NonNull Class<?> classOfFactory) {
        return BaseManagementAnnotationHandlers.obtainHandler(FragmentFactoryHandler.class, classOfFactory);
    }

    static final class FragmentFactoryHandler
    extends BaseAnnotationHandler
    implements FragmentFactoryAnnotationHandler {
        final SparseArray<FragmentItem> items;

        public FragmentFactoryHandler(final @NonNull Class<?> annotatedClass) {
            super(annotatedClass);
            int[] ids;
            final SparseArray items = new SparseArray();
            FactoryFragments fragments = this.findAnnotation(FactoryFragments.class);
            if (fragments != null && (ids = fragments.value()).length > 0) {
                for (int id : ids) {
                    items.put(id, (Object)new FragmentItem(id, Fragment.class, BaseFragmentFactory.createFragmentTag(annotatedClass, Integer.toString(id))));
                }
            }
            FragmentAnnotations.iterateFields(new FragmentAnnotations.FieldProcessor(){

                @Override
                public void onProcessField(@NonNull Field field, @NonNull String name) {
                    if (field.isAnnotationPresent(FactoryFragment.class) && Integer.TYPE.equals(field.getType())) {
                        FactoryFragment factoryFragment = field.getAnnotation(FactoryFragment.class);
                        try {
                            field.setAccessible(true);
                            int id = (Integer)field.get(null);
                            items.put(id, (Object)new FragmentItem(id, factoryFragment.value(), BaseFragmentFactory.createFragmentTag(annotatedClass, TextUtils.isEmpty((CharSequence)factoryFragment.taggedName()) ? Integer.toString(id) : factoryFragment.taggedName())));
                        }
                        catch (IllegalAccessException e) {
                            Log.e((String)FragmentFactoryAnnotationHandler.class.getSimpleName(), (String)("Failed to obtain id value from @FactoryFragment " + name + " of " + annotatedClass.getName() + "!"), (Throwable)e);
                        }
                    }
                }
            }, annotatedClass, BaseFragmentFactory.class);
            this.items = items.size() > 0 ? items : null;
        }

        @Override
        @Nullable
        public SparseArray<FragmentItem> getFragmentItems() {
            return this.items;
        }
    }
}

