/*
 * Decompiled with CFR 0.152.
 */
package universum.studios.android.fragment.annotation.handler;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import universum.studios.android.fragment.annotation.FragmentAnnotations;
import universum.studios.android.fragment.annotation.handler.AnnotationHandler;

public abstract class AnnotationHandlers {
    private static final Object LOCK = new Object();
    private static final int HANDLERS_INITIAL_CAPACITY = 20;
    private static Map<Class<?>, Object> handlers;

    AnnotationHandlers() {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static <T extends AnnotationHandler> T obtainHandler(@NonNull Class<T> classOfHandler, @NonNull Class<?> annotatedClass) {
        Object handler = null;
        if (FragmentAnnotations.isEnabled()) {
            Object object = LOCK;
            synchronized (object) {
                if (handlers == null) {
                    handlers = new HashMap(20);
                }
                if ((handler = handlers.get(annotatedClass)) == null) {
                    handler = AnnotationHandlers.instantiateHandler(classOfHandler, annotatedClass);
                    handlers.put(annotatedClass, handler);
                } else if (!handler.getClass().equals(classOfHandler)) {
                    String newHandlerName = classOfHandler.getSimpleName();
                    String currentHandlerName = handler.getClass().getSimpleName();
                    String className = annotatedClass.getSimpleName();
                    throw new ClassCastException("Trying to obtain handler(" + newHandlerName + ") for class(" + className + ") while there is already handler(" + currentHandlerName + ") of different type for that class!");
                }
            }
        }
        return (T)((AnnotationHandler)handler);
    }

    private static <T> T instantiateHandler(Class<T> classOfHandler, Class<?> annotatedClass) {
        try {
            return classOfHandler.getConstructor(Class.class).newInstance(annotatedClass);
        }
        catch (Exception e) {
            String handlerName = classOfHandler.getSimpleName();
            String className = annotatedClass.getSimpleName();
            throw new IllegalStateException("Failed to instantiate annotation handler(" + handlerName + ") for(" + className + ").", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void clearHandlers() {
        Object object = LOCK;
        synchronized (object) {
            if (handlers != null) {
                handlers.clear();
                handlers = null;
            }
        }
    }
}

