/*
 * Decompiled with CFR 0.152.
 */
package universum.studios.android.fragment;

import android.graphics.Bitmap;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.Patterns;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.WebChromeClient;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import universum.studios.android.fragment.ActionBarFragment;
import universum.studios.android.fragment.FragmentsLogging;
import universum.studios.android.fragment.annotation.FragmentAnnotations;
import universum.studios.android.fragment.annotation.handler.WebAnnotationHandlers;
import universum.studios.android.fragment.annotation.handler.WebFragmentAnnotationHandler;

public class WebFragment
extends ActionBarFragment {
    private static final String TAG = "WebFragment";
    @VisibleForTesting
    static final String BUNDLE_OPTIONS = WebFragment.class.getName() + ".BUNDLE.Options";
    @VisibleForTesting
    static final String BUNDLE_CONTENT = WebFragment.class.getName() + ".BUNDLE.Content";
    @VisibleForTesting
    static final String BUNDLE_PRIVATE_FLAGS = WebFragment.class.getName() + ".BUNDLE.PrivateFlags";
    protected static final int CONTENT_EMPTY = 0;
    protected static final int CONTENT_HTML = 1;
    protected static final int CONTENT_URL = 2;
    protected static final int CONTENT_FILE = 3;
    private static final String DATA_ENCODING = "UTF-8";
    private static final String DATA_MIME_TYPE = "text/html";
    private static final int PFLAG_READY_TO_LOAD_CONTENT = 1;
    private static final int LOG_CONTENT_MAX_LENGTH = 256;
    private static final Matcher WEB_URL_MATCHER = Patterns.WEB_URL.matcher("");
    private static final Matcher FILE_URL_MATCHER = Pattern.compile("file://(.*)").matcher("");
    private WebOptions options = new WebOptions();
    private WebView webView;
    private String content;
    private int contentType = 0;
    private OnWebContentLoadingListener contentLoadingListener;
    private int privateFlags;

    public static boolean isValidWebUrl(@Nullable String url) {
        return WEB_URL_MATCHER.reset(url).matches();
    }

    @NonNull
    public static WebFragment newInstance() {
        return WebFragment.newInstance(new WebOptions());
    }

    @NonNull
    public static WebFragment newInstance(@NonNull WebOptions options) {
        WebFragment fragment = new WebFragment();
        fragment.options = options;
        return fragment;
    }

    @Override
    WebFragmentAnnotationHandler onCreateAnnotationHandler() {
        return WebAnnotationHandlers.obtainWebFragmentHandler(this.getClass());
    }

    @Override
    @NonNull
    protected WebFragmentAnnotationHandler getAnnotationHandler() {
        FragmentAnnotations.checkIfEnabledOrThrow();
        return (WebFragmentAnnotationHandler)this.annotationHandler;
    }

    private void updatePrivateFlags(int flag, boolean add) {
        this.privateFlags = add ? (this.privateFlags |= flag) : (this.privateFlags &= ~flag);
    }

    @Override
    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (this.annotationHandler != null) {
            WebFragmentAnnotationHandler annotationHandler = (WebFragmentAnnotationHandler)this.annotationHandler;
            int contentResId = annotationHandler.getWebContentResId(-1);
            this.content = contentResId == -1 ? annotationHandler.getWebContent(null) : this.getString(contentResId);
        }
        if (savedInstanceState != null) {
            this.options = (WebOptions)savedInstanceState.getParcelable(BUNDLE_OPTIONS);
            this.privateFlags = savedInstanceState.getInt(BUNDLE_PRIVATE_FLAGS);
            this.content = savedInstanceState.getString(BUNDLE_CONTENT);
        } else if (this.options != null && !TextUtils.isEmpty((CharSequence)this.options.content)) {
            this.content = this.options.content;
        }
        this.contentType = WebFragment.resolveContentType(this.content);
    }

    @NonNull
    public final WebOptions getOptions() {
        return this.options;
    }

    public void setOnWebContentLoadingListener(@Nullable OnWebContentLoadingListener listener) {
        this.contentLoadingListener = listener;
    }

    protected void notifyLoadingStarted(@NonNull String webUrl) {
        if (this.contentLoadingListener != null) {
            this.contentLoadingListener.onLoadingStarted(webUrl);
        }
    }

    protected void notifyLoadingFinished(@NonNull String webUrl) {
        if (this.contentLoadingListener != null) {
            this.contentLoadingListener.onLoadingFinished(webUrl);
        }
    }

    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        WebChromeClient chromeClient;
        this.webView = new WebView(inflater.getContext());
        this.webView.setLayoutParams(new ViewGroup.LayoutParams(-1, -1));
        this.webView.setScrollBarStyle(0);
        WebViewClient client = this.onCreateWebViewClient();
        if (client != null) {
            this.webView.setWebViewClient(client);
        }
        if ((chromeClient = this.onCreateWebChromeClient()) != null) {
            this.webView.setWebChromeClient(chromeClient);
        }
        this.webView.getSettings().setJavaScriptEnabled(this.options.javaScriptEnabled);
        return this.webView;
    }

    @Nullable
    protected WebViewClient onCreateWebViewClient() {
        return new WebViewClient(){

            public void onPageFinished(WebView view, String url) {
                super.onPageFinished(view, url);
                WebFragment.this.notifyLoadingFinished(url);
            }

            public void onPageStarted(WebView view, String url, Bitmap favicon) {
                super.onPageStarted(view, url, favicon);
                WebFragment.this.notifyLoadingStarted(url);
            }
        };
    }

    @Nullable
    protected WebChromeClient onCreateWebChromeClient() {
        return new WebChromeClient();
    }

    @Nullable
    public WebView getWebView() {
        return this.webView;
    }

    @Override
    public void onActivityCreated(@Nullable Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
        this.updatePrivateFlags(1, true);
        if (savedInstanceState == null || this.webView == null || this.contentType == 0 || this.contentType == 1) {
            this.onLoadContent(this.content, this.contentType);
        } else {
            this.webView.restoreState(savedInstanceState);
        }
    }

    public boolean loadContent(@Nullable String content) {
        this.content = content;
        this.contentType = WebFragment.resolveContentType(this.content);
        if ((this.privateFlags & 1) != 0) {
            this.onLoadContent(this.content, this.contentType);
            return true;
        }
        return false;
    }

    @Nullable
    public String getContent() {
        return this.content;
    }

    public int getContentType() {
        return this.contentType;
    }

    @VisibleForTesting
    static int resolveContentType(@Nullable String content) {
        int contentType = TextUtils.isEmpty((CharSequence)content) ? 0 : (WEB_URL_MATCHER.reset(content).matches() ? 2 : (FILE_URL_MATCHER.reset(content).matches() ? 3 : 1));
        return contentType;
    }

    protected void onLoadContent(@Nullable String content, int type) {
        if (this.webView != null) {
            if (!TextUtils.isEmpty((CharSequence)content)) {
                if (content.length() > 256) {
                    FragmentsLogging.d(TAG, "Loading content('" + content.substring(0, 256) + "') into web view.");
                } else {
                    FragmentsLogging.d(TAG, "Loading content('" + content + "') into web view.");
                }
            }
            switch (type) {
                case 0: {
                    this.webView.loadDataWithBaseURL("", "", DATA_MIME_TYPE, DATA_ENCODING, "");
                    break;
                }
                case 2: 
                case 3: {
                    this.webView.loadUrl(content);
                    break;
                }
                default: {
                    this.webView.loadDataWithBaseURL("", content, DATA_MIME_TYPE, DATA_ENCODING, "");
                }
            }
        }
    }

    public void onSaveInstanceState(@NonNull Bundle state) {
        super.onSaveInstanceState(state);
        if (this.webView != null) {
            this.webView.saveState(state);
        }
        state.putParcelable(BUNDLE_OPTIONS, (Parcelable)this.options);
        state.putString(BUNDLE_CONTENT, this.content);
        state.putInt(BUNDLE_PRIVATE_FLAGS, this.privateFlags);
    }

    @Override
    protected boolean onBackPress() {
        if (this.webView != null && this.webView.canGoBack()) {
            this.webView.goBack();
            return true;
        }
        return false;
    }

    public void onDestroyView() {
        super.onDestroyView();
        this.updatePrivateFlags(1, false);
    }

    public static class WebOptions
    implements Parcelable {
        public static final Parcelable.Creator<WebOptions> CREATOR = new Parcelable.Creator<WebOptions>(){

            public WebOptions createFromParcel(@NonNull Parcel source) {
                return new WebOptions(source);
            }

            public WebOptions[] newArray(int size) {
                return new WebOptions[size];
            }
        };
        String content;
        boolean javaScriptEnabled;

        public WebOptions() {
            this.content = "";
            this.javaScriptEnabled = true;
        }

        protected WebOptions(@NonNull Parcel source) {
            this.content = source.readString();
            this.javaScriptEnabled = source.readInt() != 0;
        }

        public void writeToParcel(@NonNull Parcel dest, int flags) {
            dest.writeString(this.content);
            dest.writeInt(this.javaScriptEnabled ? 1 : 0);
        }

        public int describeContents() {
            return 0;
        }

        public WebOptions content(@NonNull String content) {
            this.content = content;
            return this;
        }

        public String content() {
            return this.content;
        }

        public WebOptions javaScriptEnabled(boolean enabled) {
            this.javaScriptEnabled = enabled;
            return this;
        }

        public boolean javaScriptEnabled() {
            return this.javaScriptEnabled;
        }
    }

    public static interface OnWebContentLoadingListener {
        public void onLoadingStarted(@NonNull String var1);

        public void onLoadingFinished(@NonNull String var1);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ContentType {
    }
}

