/*
 * Decompiled with CFR 0.152.
 */
package universum.studios.android.fragment;

import android.app.Activity;
import android.content.Context;
import android.content.res.Resources;
import android.os.Bundle;
import android.transition.Transition;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.CheckResult;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import universum.studios.android.fragment.ActivityDelegate;
import universum.studios.android.fragment.BackPressWatcher;
import universum.studios.android.fragment.ViewClickWatcher;
import universum.studios.android.fragment.annotation.FragmentAnnotations;
import universum.studios.android.fragment.annotation.handler.BaseAnnotationHandlers;
import universum.studios.android.fragment.annotation.handler.FragmentAnnotationHandler;
import universum.studios.android.fragment.util.FragmentUtils;

public abstract class BaseFragment
extends Fragment
implements BackPressWatcher,
ViewClickWatcher {
    private static final String TAG = "BaseFragment";
    static final int LIFECYCLE_ATTACHED = 1;
    static final int LIFECYCLE_CREATED = 2;
    static final int LIFECYCLE_STARTED = 4;
    static final int LIFECYCLE_RESUMED = 8;
    static final int LIFECYCLE_PAUSED = 16;
    static final int LIFECYCLE_STOPPED = 32;
    static final int LIFECYCLE_DESTROYED = 64;
    static final int LIFECYCLE_DETACHED = 128;
    final FragmentAnnotationHandler annotationHandler = this.onCreateAnnotationHandler();
    ActivityDelegate activityDelegate;
    private int lifecycleFlags;

    @Nullable
    public static <F extends Fragment> F newInstanceWithArguments(@NonNull Class<F> classOfFragment, @Nullable Bundle args) {
        try {
            Fragment fragment = (Fragment)classOfFragment.newInstance();
            fragment.setArguments(args);
            return (F)fragment;
        }
        catch (InstantiationException e) {
            Log.e((String)TAG, (String)("Failed to instantiate instance of " + classOfFragment + " with arguments!"), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            Log.e((String)TAG, (String)("Failed to instantiate instance of " + classOfFragment + " with arguments!"), (Throwable)e);
        }
        return null;
    }

    FragmentAnnotationHandler onCreateAnnotationHandler() {
        return BaseAnnotationHandlers.obtainFragmentHandler(this.getClass());
    }

    @NonNull
    protected FragmentAnnotationHandler getAnnotationHandler() {
        FragmentAnnotations.checkIfEnabledOrThrow();
        return this.annotationHandler;
    }

    private void updateLifecycleFlags(int flag, boolean add) {
        this.lifecycleFlags = add ? (this.lifecycleFlags |= flag) : (this.lifecycleFlags &= ~flag);
    }

    @VisibleForTesting
    boolean hasLifecycleFlag(int flag) {
        return (this.lifecycleFlags & flag) != 0;
    }

    public void onAttach(@NonNull Activity activity) {
        super.onAttach(activity);
        this.activityDelegate = ActivityDelegate.create(activity);
        this.updateLifecycleFlags(128, false);
        this.updateLifecycleFlags(1, true);
    }

    public final boolean isAttached() {
        return this.hasLifecycleFlag(1);
    }

    @NonNull
    protected Resources.Theme getContextTheme() {
        FragmentActivity activity = this.getActivity();
        if (activity == null) {
            throw new IllegalStateException("Fragment is not attached to parent context.");
        }
        return activity.getTheme();
    }

    public final boolean runOnUiThread(@NonNull Runnable action) {
        FragmentActivity activity = this.getActivity();
        if (activity != null) {
            activity.runOnUiThread(action);
            return true;
        }
        return false;
    }

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.updateLifecycleFlags(64, false);
        this.updateLifecycleFlags(2, true);
    }

    public final boolean isCreated() {
        return this.hasLifecycleFlag(2);
    }

    public void onStart() {
        super.onStart();
        this.updateLifecycleFlags(32, false);
        this.updateLifecycleFlags(4, true);
    }

    public final boolean isStarted() {
        return this.hasLifecycleFlag(4);
    }

    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        int viewResource;
        if (this.annotationHandler != null && (viewResource = this.annotationHandler.getContentViewResource(-1)) != -1) {
            if (this.annotationHandler.shouldAttachContentViewToContainer()) {
                inflater.inflate(viewResource, container, true);
                return null;
            }
            return inflater.inflate(viewResource, container, false);
        }
        return super.onCreateView(inflater, container, savedInstanceState);
    }

    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        int backgroundResId;
        super.onViewCreated(view, savedInstanceState);
        if (this.annotationHandler != null && (backgroundResId = this.annotationHandler.getContentViewBackgroundResId(-1)) != -1) {
            view.setBackgroundResource(backgroundResId);
        }
    }

    public final boolean isViewCreated() {
        return this.getView() != null;
    }

    @Nullable
    protected Transition inflateTransition(int resource) {
        FragmentActivity context = this.getActivity();
        return context == null ? null : FragmentUtils.inflateTransition((Context)context, resource);
    }

    public void onResume() {
        super.onResume();
        this.updateLifecycleFlags(16, false);
        this.updateLifecycleFlags(8, true);
    }

    public boolean invalidateOptionsMenu() {
        if (this.isAdded() && !this.isHidden()) {
            FragmentActivity activity = this.getActivity();
            if (activity == null) {
                return false;
            }
            activity.invalidateOptionsMenu();
            return true;
        }
        return false;
    }

    @Override
    public boolean dispatchViewClick(@NonNull View view) {
        this.onViewClick(view);
        return false;
    }

    protected void onViewClick(@NonNull View view) {
    }

    public void onPause() {
        super.onPause();
        this.updateLifecycleFlags(8, false);
        this.updateLifecycleFlags(16, true);
    }

    public final boolean isPaused() {
        return this.hasLifecycleFlag(16);
    }

    public void onStop() {
        super.onStop();
        this.updateLifecycleFlags(4, false);
        this.updateLifecycleFlags(32, true);
    }

    public final boolean isStopped() {
        return this.hasLifecycleFlag(32);
    }

    @Override
    @CheckResult
    public boolean dispatchBackPress() {
        return this.onBackPress();
    }

    protected boolean onBackPress() {
        return false;
    }

    public void onDestroy() {
        super.onDestroy();
        this.updateLifecycleFlags(2, false);
        this.updateLifecycleFlags(64, true);
    }

    public final boolean isDestroyed() {
        return this.hasLifecycleFlag(64);
    }

    public void onDetach() {
        super.onDetach();
        this.updateLifecycleFlags(1, false);
        this.updateLifecycleFlags(128, true);
        this.activityDelegate = null;
    }
}

