/*
 * Decompiled with CFR 0.152.
 */
package universum.studios.android.fragment;

import android.app.ActionBar;
import android.app.Activity;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import androidx.appcompat.app.AppCompatActivity;
import androidx.appcompat.view.ActionMode;

public abstract class ActivityDelegate {
    @NonNull
    final Activity activity;

    protected ActivityDelegate(@NonNull Activity activity) {
        this.activity = activity;
    }

    @NonNull
    public static ActivityDelegate create(@NonNull Activity activity) {
        if (activity instanceof AppCompatActivity) {
            return new AppCompatImpl((AppCompatActivity)activity);
        }
        return new Impl(activity);
    }

    @NonNull
    protected final Activity getActivity() {
        return this.activity;
    }

    public abstract boolean requestWindowFeature(int var1);

    public abstract void invalidateOptionsMenu();

    @Nullable
    public abstract ActionBar getActionBar();

    @Nullable
    public abstract androidx.appcompat.app.ActionBar getSupportActionBar();

    @Nullable
    public abstract ActionMode startActionMode(@NonNull ActionMode.Callback var1);

    @VisibleForTesting
    static final class AppCompatImpl
    extends Impl {
        AppCompatImpl(AppCompatActivity activity) {
            super((Activity)activity);
        }

        @Override
        public boolean requestWindowFeature(int featureId) {
            return ((AppCompatActivity)this.activity).supportRequestWindowFeature(featureId);
        }

        @Override
        public void invalidateOptionsMenu() {
            ((AppCompatActivity)this.activity).supportInvalidateOptionsMenu();
        }

        @Override
        public androidx.appcompat.app.ActionBar getSupportActionBar() {
            return ((AppCompatActivity)this.activity).getSupportActionBar();
        }

        @Override
        @Nullable
        public ActionMode startActionMode(@NonNull ActionMode.Callback callback) {
            return ((AppCompatActivity)this.activity).startSupportActionMode(callback);
        }
    }

    @VisibleForTesting
    static class Impl
    extends ActivityDelegate {
        Impl(Activity activity) {
            super(activity);
        }

        @Override
        public boolean requestWindowFeature(int featureId) {
            return this.activity.requestWindowFeature(featureId);
        }

        @Override
        public void invalidateOptionsMenu() {
            this.activity.invalidateOptionsMenu();
        }

        @Override
        @Nullable
        public ActionBar getActionBar() {
            return this.activity.getActionBar();
        }

        @Override
        @Nullable
        public androidx.appcompat.app.ActionBar getSupportActionBar() {
            return null;
        }

        @Override
        @Nullable
        public ActionMode startActionMode(@NonNull ActionMode.Callback callback) {
            return null;
        }
    }
}

